package com.zurrtum.create.client.content.fluids.pipes;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.foundation.fluid.FluidRenderer;
import com.zurrtum.create.content.fluids.FluidTransportBehaviour;
import com.zurrtum.create.content.fluids.PipeConnection.Flow;
import com.zurrtum.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class TransparentStraightPipeRenderer implements class_827<StraightPipeBlockEntity, TransparentStraightPipeRenderer.TransparentStraightPipeRenderState> {
    public TransparentStraightPipeRenderer(class_5614.class_5615 context) {
    }

    @Override
    public TransparentStraightPipeRenderState method_74335() {
        return new TransparentStraightPipeRenderState();
    }

    @Override
    public void updateRenderState(
        StraightPipeBlockEntity be,
        TransparentStraightPipeRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        FluidTransportBehaviour pipe = be.getBehaviour(FluidTransportBehaviour.TYPE);
        if (pipe == null)
            return;
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = PonderRenderTypes.fluid();
        class_2350[] directions = Iterate.directions;
        int size = directions.length;
        state.radius = 3 / 16f;
        state.data = new FluidRenderData[size];
        class_1937 world = be.method_10997();
        for (int i = 0; i < size; i++) {
            class_2350 side = directions[i];
            Flow flow = pipe.getFlow(side);
            if (flow == null) {
                continue;
            }
            FluidStack fluidStack = flow.fluid;
            if (fluidStack.isEmpty()) {
                continue;
            }
            LerpedFloat progress = flow.progress;
            if (progress == null) {
                continue;
            }
            float value = progress.getValue(tickProgress);
            boolean inbound = flow.inbound;
            if (value == 1) {
                if (inbound) {
                    Flow opposite = pipe.getFlow(side.method_10153());
                    if (opposite == null)
                        value -= 1e-6f;
                } else {
                    FluidTransportBehaviour adjacent = BlockEntityBehaviour.get(world, state.field_62673.method_10093(side), FluidTransportBehaviour.TYPE);
                    if (adjacent == null)
                        value -= 1e-6f;
                    else {
                        Flow other = adjacent.getFlow(side.method_10153());
                        if (other == null || !other.inbound && !other.complete)
                            value -= 1e-6f;
                    }
                }
            }
            state.data[i] = new FluidRenderData(fluidStack.getFluid(), fluidStack.getComponentChanges(), side, value, inbound);
        }
    }

    @Override
    public void render(
        TransparentStraightPipeRenderState state,
        class_4587 matrices,
        class_11659 queue,
        class_12075 cameraState
    ) {
        if (state.data != null) {
            queue.method_73483(matrices, state.layer, state);
        }
    }

    public static class TransparentStraightPipeRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public float radius;
        public FluidRenderData[] data;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (FluidRenderData renderData : data) {
                if (renderData == null) {
                    continue;
                }
                FluidRenderer.renderFluidStream(
                    renderData.fluid,
                    renderData.changes,
                    renderData.side,
                    radius,
                    renderData.value,
                    renderData.inbound,
                    vertexConsumer,
                    matricesEntry,
                    field_62676
                );
            }
        }
    }

    public record FluidRenderData(
        class_3611 fluid, class_9326 changes, class_2350 side, float value, boolean inbound
    ) {
    }
}
