package com.zurrtum.create.client.content.kinetics;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;

public class KineticDebugger {
    public static boolean rainbowDebug = false;

    public static void tick(class_310 mc) {
        if (!isActive()) {
            if (KineticBlockEntityRenderer.rainbowMode) {
                KineticBlockEntityRenderer.rainbowMode = false;
                SuperByteBufferCache.getInstance().invalidate();
            }
            return;
        }

        KineticBlockEntity be = getSelectedBE(mc);
        if (be == null)
            return;

        class_1937 world = mc.field_1687;
        class_2338 toOutline = be.hasSource() ? be.source : be.method_11016();
        class_2680 state = be.method_11010();
        class_265 shape = world.method_8320(toOutline).method_26222(world, toOutline);

        if (be.getTheoreticalSpeed() != 0 && !shape.method_1110())
            Outliner.getInstance().chaseAABB("kineticSource", shape.method_1107().method_996(toOutline)).lineWidth(1 / 16f)
                .colored(be.hasSource() ? Color.generateFromLong(be.network).getRGB() : 0xffcc00);

        if (state.method_26204() instanceof IRotate rotate) {
            class_2351 axis = rotate.getRotationAxis(state);
            class_243 vec = class_243.method_24954(class_2350.method_10156(class_2352.field_11056, axis).method_62675());
            class_243 center = VecHelper.getCenterOf(be.method_11016());
            Outliner.getInstance().showLine("rotationAxis", center.method_1019(vec), center.method_1020(vec)).lineWidth(1 / 16f);
        }

    }

    public static boolean isActive() {
        return isF3DebugModeActive() && KineticDebugger.rainbowDebug;
    }

    public static boolean isF3DebugModeActive() {
        return class_310.method_1551().method_53526().method_53536();
    }

    public static KineticBlockEntity getSelectedBE(class_310 mc) {
        class_239 obj = mc.field_1765;
        if (obj == null)
            return null;
        class_638 world = mc.field_1687;
        if (world == null)
            return null;
        if (!(obj instanceof class_3965 ray))
            return null;

        class_2586 be = world.method_8321(ray.method_17777());
        if (!(be instanceof KineticBlockEntity))
            return null;

        return (KineticBlockEntity) be;
    }

}
