package com.zurrtum.create.client.content.kinetics.deployer;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

import static com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;
import static com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock.FACING;

public class DeployerActorVisual extends ActorVisual {

    class_2350 facing;
    boolean stationaryTimer;

    TransformedInstance pole;
    TransformedInstance hand;
    RotatingInstance shaft;

    Matrix4fc baseHandTransform;
    Matrix4fc basePoleTransform;

    public DeployerActorVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext context) {
        super(visualizationContext, simulationWorld, context);
        class_2680 state = context.state;
        Mode mode = context.blockEntityData.method_67491("Mode", Mode.CODEC).orElse(Mode.PUNCH);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);

        stationaryTimer = context.data.method_10545("StationaryTimer");
        facing = state.method_11654(FACING);

        boolean rotatePole = state.method_11654(AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2350.class_2351.field_11051;
        float yRot = AngleHelper.horizontalAngle(facing);
        float xRot = facing == class_2350.field_11036 ? 270 : facing == class_2350.field_11033 ? 90 : 0;
        float zRot = rotatePole ? 90 : 0;

        pole = instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.DEPLOYER_POLE)).createInstance();
        hand = instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(handPose)).createInstance();

        class_2350.class_2351 axis = KineticBlockEntityVisual.rotationAxis(state);
        shaft = instancerProvider.instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT)).createInstance().rotateToFace(axis);

        int blockLight = localBlockLight();

        shaft.setRotationAxis(axis).setRotationOffset(KineticBlockEntityVisual.rotationOffset(state, axis, context.localPos))
            .setPosition(context.localPos).light(blockLight, 0).setChanged();

        pole.translate(context.localPos).center().rotate(yRot * class_3532.field_29847, class_2350.field_11036)
            .rotate(xRot * class_3532.field_29847, class_2350.field_11034).rotate(zRot * class_3532.field_29847, class_2350.field_11035).uncenter()
            .light(blockLight, 0).setChanged();

        basePoleTransform = new Matrix4f(pole.pose);

        hand.translate(context.localPos).center().rotate(yRot * class_3532.field_29847, class_2350.field_11036)
            .rotate(xRot * class_3532.field_29847, class_2350.field_11034).uncenter().light(blockLight, 0).setChanged();

        baseHandTransform = new Matrix4f(hand.pose);
    }

    @Override
    public void beginFrame() {
        float distance = deploymentDistance();

        pole.setTransform(basePoleTransform).translateZ(distance).setChanged();

        hand.setTransform(baseHandTransform).translateZ(distance).setChanged();
    }

    private float deploymentDistance() {
        double factor;
        if (context.disabled) {
            factor = 0;
        } else if (context.contraption.stalled || context.position == null || context.data.method_10545("StationaryTimer")) {
            factor = class_3532.method_15374(AnimationTickHolder.getRenderTime() * .5f) * .25f + .25f;
        } else {
            class_243 center = VecHelper.getCenterOf(class_2338.method_49638(context.position));
            double distance = context.position.method_1022(center);
            double nextDistance = context.position.method_1019(context.motion).method_1022(center);
            factor = .5f - class_3532.method_15350(class_3532.method_16436(AnimationTickHolder.getPartialTicks(), distance, nextDistance), 0, 1);
        }
        return (float) factor;
    }

    @Override
    protected void _delete() {
        pole.delete();
        hand.delete();
        shaft.delete();
    }
}
