package com.zurrtum.create.client.content.kinetics.speedController;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlock;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class SpeedControllerRenderer implements class_827<SpeedControllerBlockEntity, SpeedControllerRenderer.SpeedControllerRenderState> {
    public SpeedControllerRenderer(class_5614.class_5615 context) {
    }

    @Override
    public SpeedControllerRenderState method_74335() {
        return new SpeedControllerRenderState();
    }

    @Override
    public void updateRenderState(
        SpeedControllerBlockEntity be,
        SpeedControllerRenderState state,
        float tickProgress,
        class_243 cameraPos,
        class_11683.@Nullable class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        class_1937 world = be.method_10997();
        state.render = !VisualizationManager.supportsVisualization(world);
        if (state.render) {
            state.model = getRotatedModel(be);
            class_2351 axis = ((IRotate) state.field_62674.method_26204()).getRotationAxis(state.field_62674);
            state.direction = class_2350.method_10169(axis, class_2350.class_2352.field_11056);
            state.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.field_62673, axis);
            state.color = KineticBlockEntityRenderer.getColor(be);
        }
        state.hasBracket = be.hasBracket;
        if (state.hasBracket) {
            state.bracket = CachedBuffers.partial(AllPartialModels.SPEED_CONTROLLER_BRACKET, state.field_62674);
            boolean alongX = state.field_62674.method_11654(SpeedControllerBlock.HORIZONTAL_AXIS) == class_2351.field_11048;
            state.bracketAngle = (float) (alongX ? Math.PI : Math.PI / 2);
            state.bracketLight = world != null ? class_761.method_23794(
                world,
                state.field_62673.method_10084()
            ) : class_765.field_32767;
        }
        if (state.render || state.hasBracket) {
            state.layer = class_1921.method_23577();
        }
    }

    @Override
    public void render(SpeedControllerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.render || state.hasBracket) {
            queue.method_73483(matrices, state.layer, state);
        }
    }

    private SuperByteBuffer getRotatedModel(SpeedControllerBlockEntity blockEntity) {
        return CachedBuffers.block(
            KineticBlockEntityRenderer.KINETIC_BLOCK,
            KineticBlockEntityRenderer.shaft(KineticBlockEntityRenderer.getRotationAxisOf(blockEntity))
        );
    }

    public static class SpeedControllerRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public boolean render;
        public SuperByteBuffer model;
        public class_2350 direction;
        public float angle;
        public Color color;
        public boolean hasBracket;
        public SuperByteBuffer bracket;
        public float bracketAngle;
        public int bracketLight;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (render) {
                model.light(field_62676);
                model.rotateCentered(angle, direction);
                model.color(color);
                model.renderInto(matricesEntry, vertexConsumer);
            }
            if (hasBracket) {
                bracket.translate(0, 1, 0);
                bracket.rotateCentered(bracketAngle, class_2350.field_11036);
                bracket.light(bracketLight);
                bracket.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}
