package com.zurrtum.create.client.content.kinetics.steamEngine;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class SteamEngineRenderer implements class_827<SteamEngineBlockEntity, SteamEngineRenderer.SteamEngineRenderState> {
    public SteamEngineRenderer(class_5614.class_5615 context) {
    }

    @Override
    public SteamEngineRenderState method_74335() {
        return new SteamEngineRenderState();
    }

    @Override
    public void updateRenderState(
        SteamEngineBlockEntity be,
        SteamEngineRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        if (VisualizationManager.supportsVisualization(be.method_10997())) {
            return;
        }
        Float angle = getTargetAngle(be);
        if (angle == null) {
            return;
        }
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_1921.method_23577();
        class_2350 facing = SteamEngineBlock.getFacing(state.field_62674);
        class_2351 facingAxis = facing.method_10166();
        class_2351 axis = class_2351.field_11052;
        PoweredShaftBlockEntity shaft = be.getShaft();
        if (shaft != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        }
        boolean roll90 = facingAxis.method_10179() && axis == class_2351.field_11052 || facingAxis.method_10178() && axis == class_2351.field_11051;
        float sinAngle = class_3532.method_15374(angle);
        float cosAngle = class_3532.method_15362(angle);
        float piston = ((6 / 16f) * sinAngle - class_3532.method_15355(class_3532.method_27285(14 / 16f) - class_3532.method_27285(6 / 16f) * class_3532.method_27285(cosAngle)));
        float distance = class_3532.method_15355(class_3532.method_27285(piston - 6 / 16f * sinAngle));
        state.piston = CachedBuffers.partial(AllPartialModels.ENGINE_PISTON, state.field_62674);
        state.linkage = CachedBuffers.partial(AllPartialModels.ENGINE_LINKAGE, state.field_62674);
        state.connector = CachedBuffers.partial(AllPartialModels.ENGINE_CONNECTOR, state.field_62674);
        state.yRot = AngleHelper.horizontalAngle(facing);
        state.xRot = AngleHelper.verticalAngle(facing) + 90;
        state.roll = roll90 ? -90 : 0;
        state.linkageRotate = (float) Math.acos(distance / (14 / 16f)) * (cosAngle >= 0 ? 1f : -1f);
        state.pistonTranslate = piston + 20 / 16f;
        state.connectorRotate = -(angle + class_3532.field_29845);
    }

    @Override
    public void render(SteamEngineRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.layer != null) {
            queue.method_73483(matrices, state.layer, state);
        }
    }

    @Override
    public int method_33893() {
        return 128;
    }

    @Nullable
    public static Float getTargetAngle(SteamEngineBlockEntity be) {
        class_2680 blockState = be.method_11010();
        if (!blockState.method_27852(AllBlocks.STEAM_ENGINE))
            return null;

        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        PoweredShaftBlockEntity shaft = be.getShaft();
        class_2351 facingAxis = facing.method_10166();

        if (shaft == null)
            return null;

        class_2351 axis = KineticBlockEntityRenderer.getRotationAxisOf(shaft);
        float angle = KineticBlockEntityRenderer.getAngleForBe(shaft, shaft.method_11016(), axis);

        if (axis == facingAxis)
            return null;
        if (axis.method_10179() && (facingAxis == class_2351.field_11048 ^ facing.method_10171() == class_2350.class_2352.field_11056))
            angle *= -1;
        if (axis == class_2351.field_11048 && facing == class_2350.field_11033)
            angle *= -1;
        return angle;
    }

    public static class SteamEngineRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer piston;
        public SuperByteBuffer linkage;
        public SuperByteBuffer connector;
        public float yRot;
        public float xRot;
        public int roll;
        public float linkageRotate;
        public float pistonTranslate;
        public float connectorRotate;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            piston.center().rotateYDegrees(yRot).rotateXDegrees(xRot).rotateYDegrees(roll).uncenter().translate(0, pistonTranslate, 0)
                .light(field_62676).renderInto(matricesEntry, vertexConsumer);
            linkage.center().rotateYDegrees(yRot).rotateXDegrees(xRot).rotateYDegrees(roll).translate(0, 1, 0).uncenter()
                .translate(0, pistonTranslate, 0).translate(0, 0.25f, 0.5f).rotateX(linkageRotate).translate(0, -0.25f, -0.5f)
                .light(field_62676).renderInto(matricesEntry, vertexConsumer);
            connector.center().rotateYDegrees(yRot).rotateXDegrees(xRot).rotateYDegrees(roll).uncenter().translate(0, 2, 0).center()
                .rotateX(connectorRotate).uncenter().light(field_62676).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
