package com.zurrtum.create.client.content.logistics.filter;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.FontHelper.Palette;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.content.logistics.filter.AbstractFilterMenu;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket.Option;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_768;

import static com.zurrtum.create.client.foundation.gui.AllGuiTextures.PLAYER_INVENTORY;

public abstract class AbstractFilterScreen<F extends AbstractFilterMenu> extends AbstractSimiContainerScreen<F> {

    protected AllGuiTextures background;
    private List<class_768> extraAreas = Collections.emptyList();

    private IconButton resetButton;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    protected AbstractFilterScreen(F menu, class_1661 inv, class_2561 title, AllGuiTextures background) {
        super(menu, inv, title);
        this.background = background;
    }

    @Override
    protected void method_25426() {
        setWindowSize(Math.max(background.getWidth(), PLAYER_INVENTORY.getWidth()), background.getHeight() + 4 + PLAYER_INVENTORY.getHeight());
        super.method_25426();

        resetButton = new IconButton(field_2776 + background.getWidth() - 62, field_2800 + background.getHeight() - 24, AllIcons.I_TRASH);
        resetButton.withCallback(() -> {
            field_2797.clearContents();
            contentsCleared();
            field_22787.field_1724.field_3944.method_52787(AllPackets.CLEAR_CONTAINER);
        });
        confirmButton = new IconButton(field_2776 + background.getWidth() - 33, field_2800 + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> {
            field_22787.field_1724.method_7346();
        });

        method_37063(resetButton);
        method_37063(confirmButton);

        extraAreas = ImmutableList.of(new class_768(field_2776 + background.getWidth(), field_2800 + background.getHeight() - 40, 80, 48));

        renderedItem = new ElementWidget(
            field_2776 + background.getWidth() + 8,
            field_2800 + background.getHeight() - 52
        ).showingElement(GuiGameElement.of(field_2797.contentHolder).scale(4));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = getLeftOfCentered(PLAYER_INVENTORY.getWidth());
        int invY = field_2800 + background.getHeight() + 4;
        renderPlayerInventory(graphics, invX, invY);

        background.render(graphics, field_2776, field_2800);
        graphics.method_51439(field_22793, field_22785, field_2776 + (background.getWidth() - 8) / 2 - field_22793.method_27525(field_22785) / 2, field_2800 + 4, getTitleColor(), false);
    }

    protected int getTitleColor() {
        return 0xFF592424;
    }

    @Override
    protected void method_37432() {
        if (!class_1799.method_7973(field_22787.field_1724.method_6047(), field_2797.contentHolder))
            field_22787.field_1724.method_7346();

        super.method_37432();

        handleTooltips();
        handleIndicators();
    }

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = getTooltipButtons();

        for (IconButton button : tooltipButtons) {
            if (!button.getToolTip().isEmpty()) {
                button.setToolTip(button.getToolTip().get(0));
                button.getToolTip().add(TooltipHelper.holdShift(Palette.YELLOW, AllKeys.hasShiftDown()));
            }
        }

        if (AllKeys.hasShiftDown()) {
            List<class_5250> tooltipDescriptions = getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); i++)
                fillToolTip(tooltipButtons.get(i), tooltipDescriptions.get(i));
        }
    }

    public void handleIndicators() {
        for (IconButton button : getTooltipButtons())
            button.green = !isButtonEnabled(button);
    }

    protected abstract boolean isButtonEnabled(IconButton button);

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<class_5250> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, class_2561 tooltip) {
        if (!button.method_25367())
            return;
        List<class_2561> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent(tooltip, Palette.ALL_GRAY));
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(Option option) {
        field_22787.field_1724.field_3944.method_52787(new FilterScreenPacket(option));
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}
