package com.zurrtum.create.client.content.logistics.tunnel;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.FlapStuffs;
import com.zurrtum.create.client.content.logistics.FlapStuffs.FlapsRenderState;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_5614;

public class BeltTunnelRenderer extends SmartBlockEntityRenderer<BeltTunnelBlockEntity, BeltTunnelRenderer.BeltTunnelRenderState> {
    public BeltTunnelRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public BeltTunnelRenderState createRenderState() {
        return new BeltTunnelRenderState();
    }

    @Override
    public void updateRenderState(
        BeltTunnelBlockEntity be,
        BeltTunnelRenderState state,
        float tickProgress,
        class_243 cameraPos,
        class_11683.@Nullable class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (VisualizationManager.supportsVisualization(be.method_10997())) {
            return;
        }
        SuperByteBuffer flapBuffer = CachedBuffers.partial(AllPartialModels.BELT_TUNNEL_FLAP, state.blockState);
        List<FlapsRenderState> flaps = new ArrayList<>();
        for (class_2350 direction : Iterate.directions) {
            if (!be.flaps.containsKey(direction)) {
                continue;
            }
            float f = be.flaps.get(direction).getValue(tickProgress);
            flaps.add(FlapStuffs.getFlapsRenderState(flapBuffer, FlapStuffs.TUNNEL_PIVOT, direction, f, 0, state.lightmapCoordinates));
        }
        state.flaps = flaps;
    }

    @Override
    public void render(BeltTunnelRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        if (state.flaps != null) {
            class_1921 layer = class_1921.method_23577();
            for (FlapsRenderState flap : state.flaps) {
                flap.render(layer, matrices, queue);
            }
        }
    }

    public static class BeltTunnelRenderState extends SmartRenderState {
        public List<FlapsRenderState> flaps;
    }
}
