package com.zurrtum.create.client.content.processing.basin;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.content.processing.basin.BasinInventory;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour.TankSegment;
import com.zurrtum.create.infrastructure.fluids.BucketFluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_9326;
import net.minecraft.util.math.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class BasinRenderer extends SmartBlockEntityRenderer<BasinBlockEntity, BasinRenderer.BasinRenderState> {
    public BasinRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public BasinRenderState createRenderState() {
        return new BasinRenderState();
    }

    @Override
    public void updateRenderState(
        BasinBlockEntity be,
        BasinRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        float fluidLevel = updateFluids(be, state, tickProgress);
        updateIngredients(be, state, tickProgress, fluidLevel);
        updateOutputs(be, state, tickProgress);
    }

    @Override
    public void render(BasinRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        if (state.fluids != null) {
            queue.method_73483(matrices, state.layer, state);
        }
        if (state.ingredients != null) {
            matrices.method_22903();
            matrices.method_22904(.5, .2f, .5);
            matrices.method_22907(class_7833.field_40716.rotation(state.ingredientYRot));
            for (IngredientRenderData ingredient : state.ingredients) {
                matrices.method_22903();
                matrices.method_61958(ingredient.itemPosition);
                matrices.method_22907(class_7833.field_40716.rotation(ingredient.yRot));
                matrices.method_22907(class_7833.field_40714.rotation(state.ingredientXRot));
                for (class_243 offset : ingredient.offsets) {
                    matrices.method_22903();
                    matrices.method_61958(offset);
                    ingredient.renderState.method_65604(matrices, queue, state.lightmapCoordinates, class_4608.field_21444, 0);
                    matrices.method_22909();
                }
                matrices.method_22909();
            }
            matrices.method_22909();
        }
        if (state.outputs != null) {
            for (OutputItemRenderData item : state.outputs) {
                matrices.method_22903();
                matrices.method_61958(item.offset);
                matrices.method_22907(class_7833.field_40716.rotation(state.outputYRot));
                matrices.method_22907(class_7833.field_40714.rotation(item.xRot));
                item.renderState.method_65604(matrices, queue, state.lightmapCoordinates, class_4608.field_21444, 0);
                matrices.method_22909();
            }
        }
    }

    public float updateFluids(BasinBlockEntity basin, BasinRenderState state, float partialTicks) {
        float totalUnits = basin.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1)
            return 0;
        float xMin = 2 / 16f;
        float xMax = 2 / 16f;
        List<FluidRenderData> fluids = new ArrayList<>();
        for (SmartFluidTankBehaviour behaviour : List.of(
            basin.getBehaviour(SmartFluidTankBehaviour.INPUT),
            basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT)
        )) {
            if (behaviour == null)
                continue;
            for (TankSegment tankSegment : behaviour.getTanks()) {
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty())
                    continue;
                float units = tankSegment.getTotalUnits(partialTicks);
                if (units < 1)
                    continue;

                float partial = class_3532.method_15363(units / totalUnits, 0, 1);
                xMax += partial * 12 / 16f;
                fluids.add(new FluidRenderData(renderedFluid.getFluid(), renderedFluid.getComponentChanges(), xMin, xMax));

                xMin = xMax;
            }
        }
        if (fluids.isEmpty()) {
            return 0;
        }
        float fluidLevel = class_3532.method_15363(totalUnits / (BucketFluidInventory.CAPACITY * 2), 0, 1);
        fluidLevel = 1 - ((1 - fluidLevel) * (1 - fluidLevel));
        state.layer = ShadersModHelper.isShaderPackInUse() ? class_1921.method_29380() : PonderRenderTypes.fluid();
        state.fluids = fluids;
        state.yMin = 2 / 16f;
        state.yMax = state.yMin + 12 / 16f * fluidLevel;
        state.zMin = 2 / 16f;
        state.zMax = 14 / 16f;
        return state.yMax;
    }

    public void updateIngredients(BasinBlockEntity be, BasinRenderState state, float partialTicks, float fluidLevel) {
        BasinInventory inv = be.itemCapability;
        if (inv == null) {
            return;
        }
        List<class_1799> stacks = new ArrayList<>();
        for (int slot = 0, size = inv.method_5439(); slot < size; slot++) {
            class_1799 stack = inv.method_5438(slot);
            if (stack.method_7960()) {
                continue;
            }
            stacks.add(stack);
        }
        int itemCount = stacks.size();
        if (itemCount == 0) {
            return;
        }
        float level = class_3532.method_15363(fluidLevel - .3f, .125f, .6f);
        class_5819 r = class_5819.method_43049(state.pos.hashCode());
        class_243 baseVector = new class_243(itemCount == 1 ? 0 : .125, level, 0);
        class_1937 world = be.method_10997();
        float time = AnimationTickHolder.getRenderTime(world);
        float anglePartition = 360f / itemCount;
        IngredientRenderData[] ingredients = new IngredientRenderData[itemCount];
        for (int i = 0, size = itemCount; i < size; i++) {
            class_1799 stack = stacks.get(i);
            class_243 itemPosition = VecHelper.rotate(baseVector, anglePartition * itemCount, class_2351.field_11052);
            if (fluidLevel > 0) {
                itemPosition = itemPosition.method_1031(0, (class_3532.method_15374(time / 12f + anglePartition * itemCount) + 1.5f) * 1 / 32f, 0);
            }
            float yRot = class_3532.field_29847 * (anglePartition * itemCount + 35);
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4318;
            itemModelManager.method_65596(renderState, stack, renderState.field_55337, world, null, 0);
            int count = stack.method_7947() / 8 + 1;
            class_243[] offsets = new class_243[count];
            for (int j = 0; j < count; j++) {
                offsets[j] = VecHelper.offsetRandomly(class_243.field_1353, r, 1 / 16f);
            }
            ingredients[i] = new IngredientRenderData(renderState, itemPosition, yRot, offsets);
            itemCount--;
        }
        state.ingredientYRot = class_3532.field_29847 * be.ingredientRotation.getValue(partialTicks);
        state.ingredientXRot = class_3532.field_29847 * 65;
        state.ingredients = ingredients;
    }

    private void updateOutputs(BasinBlockEntity be, BasinRenderState state, float partialTicks) {
        if (!(state.blockState.getBlock() instanceof BasinBlock)) {
            return;
        }
        class_2350 direction = state.blockState.get(BasinBlock.FACING);
        if (direction == class_2350.field_11033) {
            return;
        }
        List<IntAttached<class_1799>> visualizedOutputItems = be.visualizedOutputItems;
        if (visualizedOutputItems.isEmpty()) {
            return;
        }
        class_243 directionVec = class_243.method_24954(direction.method_62675());
        class_243 outVec = VecHelper.getCenterOf(class_2338.field_11176).method_1019(directionVec.method_1021(.55).method_1023(0, 1 / 2f, 0));
        class_1937 world = be.method_10997();
        boolean outToBasin = world.method_8320(state.pos.offset(direction)).getBlock() instanceof BasinBlock;
        List<OutputItemRenderData> outputs = new ArrayList<>();
        for (IntAttached<class_1799> intAttached : visualizedOutputItems) {
            float progress = 1 - (intAttached.getFirst() - partialTicks) / BasinBlockEntity.OUTPUT_ANIMATION_TIME;
            if (!outToBasin && progress > .35f) {
                continue;
            }
            class_243 offset = outVec.method_1031(0, Math.max(-.55f, -(progress * progress * 2)), 0).method_1019(directionVec.method_1021(progress * .5f));
            float xRot = class_3532.field_29847 * progress * 180;
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4318;
            itemModelManager.method_65596(renderState, intAttached.getValue(), renderState.field_55337, world, null, 0);
            outputs.add(new OutputItemRenderData(renderState, offset, xRot));
        }
        if (outputs.isEmpty()) {
            return;
        }
        state.outputYRot = class_3532.field_29847 * AngleHelper.horizontalAngle(direction);
        state.outputs = outputs;
    }

    @Override
    public int method_33893() {
        return 16;
    }

    public static class BasinRenderState extends SmartRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public float yMin, yMax, zMin, zMax;
        public List<FluidRenderData> fluids;
        public float ingredientYRot, ingredientXRot;
        public IngredientRenderData[] ingredients;
        public float outputYRot;
        public List<OutputItemRenderData> outputs;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (FluidRenderData data : fluids) {
                FluidRenderHelper.renderFluidBox(
                    data.fluid,
                    data.changes,
                    data.xMin,
                    yMin,
                    zMin,
                    data.xMax,
                    yMax,
                    zMax,
                    vertexConsumer,
                    matricesEntry,
                    lightmapCoordinates,
                    false,
                    false
                );
            }
        }
    }

    public record FluidRenderData(class_3611 fluid, class_9326 changes, float xMin, float xMax) {
    }

    public record IngredientRenderData(class_10444 renderState, class_243 itemPosition, float yRot, class_243[] offsets) {
    }

    public record OutputItemRenderData(class_10444 renderState, class_243 offset, float xRot) {
    }
}
