package com.zurrtum.create.client.content.redstone.deskBell;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.redstone.deskBell.DeskBellBlock;
import com.zurrtum.create.content.redstone.deskBell.DeskBellBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class DeskBellRenderer extends SmartBlockEntityRenderer<DeskBellBlockEntity, DeskBellRenderer.DeskBellRenderState> {
    public DeskBellRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public DeskBellRenderState createRenderState() {
        return new DeskBellRenderState();
    }

    @Override
    public void updateRenderState(
        DeskBellBlockEntity be,
        DeskBellRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        float p = be.animation.getValue(tickProgress);
        if (p < 0.004 && !state.blockState.get(DeskBellBlock.POWERED, false)) {
            return;
        }
        state.layer = class_1921.method_23577();
        float f = (float) (1 - 4 * Math.pow((Math.max(p - 0.5, 0)) - 0.5, 2));
        float f2 = (float) (Math.pow(p, 1.25f));
        class_2350 facing = state.blockState.get(DeskBellBlock.field_10927);
        state.yRot = class_3532.field_29847 * AngleHelper.horizontalAngle(facing);
        state.xRot = class_3532.field_29847 * (AngleHelper.verticalAngle(facing) + 90);
        state.plunger = CachedBuffers.partial(AllPartialModels.DESK_BELL_PLUNGER, state.blockState);
        state.plungerOffset = f * -.75f / 16f;
        state.bell = CachedBuffers.partial(AllPartialModels.DESK_BELL_BELL, state.blockState);
        state.bellOffset = -1 / 16;
        float offset = p * class_3532.field_29844 * 4 + be.animationOffset;
        state.bellXRot = class_3532.field_29847 * (f2 * 8 * class_3532.method_15374(offset));
        state.bellZRot = class_3532.field_29847 * (f2 * 8 * class_3532.method_15362(offset));
    }

    @Override
    public void render(DeskBellRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        if (state.layer != null) {
            queue.method_73483(matrices, state.layer, state);
        }
    }

    public static class DeskBellRenderState extends SmartRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public float yRot;
        public float xRot;
        public SuperByteBuffer plunger;
        public float plungerOffset;
        public SuperByteBuffer bell;
        public int bellOffset;
        public float bellXRot;
        public float bellZRot;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            plunger.center().rotateY(yRot).rotateX(xRot).uncenter().translate(0, plungerOffset, 0);
            plunger.light(lightmapCoordinates).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
            bell.center().rotateY(yRot).rotateX(xRot).translate(0, bellOffset, 0).rotateX(bellXRot).rotateZ(bellZRot).translate(0, -bellOffset, 0);
            bell.scale(0.995f).uncenter().light(lightmapCoordinates).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
