package com.zurrtum.create.client.content.redstone.displayLink;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.api.behaviour.display.ClickToLinkSelection;
import com.zurrtum.create.api.behaviour.display.DisplayTarget;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.content.redstone.displayLink.ClickToLinkBlockItem;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_310;

public class ClickToLinkHandler {
    private static class_2338 lastShownPos = null;
    private static class_238 lastShownAABB = null;

    public static void clientTick(class_310 mc) {
        class_1657 player = mc.field_1724;
        if (player == null)
            return;
        class_1799 heldItemMainhand = player.method_6047();
        if (!(heldItemMainhand.method_7909() instanceof ClickToLinkBlockItem blockItem))
            return;
        if (!heldItemMainhand.method_57826(AllDataComponents.CLICK_TO_LINK_DATA))
            return;

        //noinspection DataFlowIssue
        class_2338 selectedPos = heldItemMainhand.method_58694(AllDataComponents.CLICK_TO_LINK_DATA).selectedPos();

        if (!selectedPos.equals(lastShownPos)) {
            if (blockItem instanceof ClickToLinkSelection item) {
                lastShownAABB = item.getSelectionBounds(mc.field_1687, selectedPos);
            } else {
                lastShownAABB = getSelectionBounds(mc.field_1687, selectedPos);
            }
            lastShownPos = selectedPos;
        }

        Outliner.getInstance().showAABB("target", lastShownAABB).colored(0xffcb74).lineWidth(1 / 16f);
    }

    public static class_238 getSelectionBounds(class_1937 world, class_2338 pos) {
        DisplayTarget target = DisplayTarget.get(world, pos);
        if (target != null) {
            return target.getMultiblockBounds(world, pos);
        }
        class_265 shape = world.method_8320(pos).method_26218(world, pos);
        return shape.method_1110() ? new class_238(class_2338.field_10980) : shape.method_1107().method_996(pos);
    }
}
