package com.zurrtum.create.client.content.redstone.link;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class LinkBehaviour extends BlockEntityBehaviour<SmartBlockEntity> {
    public static final BehaviourType<LinkBehaviour> TYPE = new BehaviourType<>();
    ValueBoxTransform firstSlot;
    ValueBoxTransform secondSlot;
    ServerLinkBehaviour behaviour;

    public LinkBehaviour(SmartBlockEntity be) {
        super(be);
        firstSlot = new RedstoneLinkFrequencySlot(true);
        secondSlot = new RedstoneLinkFrequencySlot(false);
    }

    @Override
    public void initialize() {
        behaviour = blockEntity.getBehaviour(ServerLinkBehaviour.TYPE);
    }

    @Override
    public void onBehaviourAdded(BehaviourType<?> type, BlockEntityBehaviour<?> behaviour) {
        if (type == ServerLinkBehaviour.TYPE) {
            this.behaviour = (ServerLinkBehaviour) behaviour;
        }
    }

    public void setFrequency(boolean first, class_1799 heldItem) {
        behaviour.setFrequency(first, heldItem);
    }

    public boolean testHit(Boolean first, class_243 hit) {
        class_2680 state = blockEntity.method_11010();
        class_243 localHit = hit.method_1020(class_243.method_24954(blockEntity.method_11016()));
        return (first ? firstSlot : secondSlot).testHit(getWorld(), getPos(), state, localHit);
    }

    public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
        return behaviour.getNetworkKey();
    }

    public class_1799 getFirstStack() {
        return behaviour.frequencyFirst.getStack();
    }

    public class_1799 getLastStack() {
        return behaviour.frequencyLast.getStack();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public float getRenderDistance() {
        return AllConfigs.client().filterItemRenderDistance.getF();
    }
}
