package com.zurrtum.create.client.content.redstone.link.controller;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.catnip.lang.FontHelper.Palette;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.model.LinkedControllerModel;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerBindPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerInputPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerStopLecternPacket;
import org.joml.Matrix3x2fStack;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_8001;

public class LinkedControllerClientHandler {
    public static Mode MODE = Mode.IDLE;
    public static int PACKET_RATE = 5;
    public static Collection<Integer> currentlyPressed = new HashSet<>();
    private static class_2338 lecternPos;
    private static class_2338 selectedLocation = class_2338.field_10980;
    private static int packetCooldown;

    public static void toggleBindMode(class_746 player, class_2338 location) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.BIND;
            selectedLocation = location;
        } else {
            MODE = Mode.IDLE;
            onReset(player);
        }
    }

    public static void toggle(class_746 player) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = null;
        } else {
            MODE = Mode.IDLE;
            onReset(player);
        }
    }

    public static void activateInLectern(class_2338 lecternAt) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = lecternAt;
        }
    }

    public static boolean deactivateInLectern(class_746 player) {
        if (MODE == Mode.ACTIVE && inLectern()) {
            MODE = Mode.IDLE;
            onReset(player);
            return true;
        }
        return false;
    }

    public static boolean inLectern() {
        return lecternPos != null;
    }

    protected static void onReset(class_746 player) {
        ControlsUtil.getControls().forEach(kb -> kb.method_23481(ControlsUtil.isActuallyPressed(kb)));
        packetCooldown = 0;
        selectedLocation = class_2338.field_10980;

        if (inLectern())
            player.field_3944.method_52787(new LinkedControllerStopLecternPacket(lecternPos));
        lecternPos = null;

        if (!currentlyPressed.isEmpty())
            player.field_3944.method_52787(new LinkedControllerInputPacket(currentlyPressed, false));
        currentlyPressed.clear();

        LinkedControllerModel.resetButtons();
    }

    public static void tick(class_310 mc) {
        LinkedControllerModel.tick(mc);

        if (MODE == Mode.IDLE)
            return;
        if (packetCooldown > 0)
            packetCooldown--;

        class_746 player = mc.field_1724;
        class_638 world = mc.field_1687;
        class_1799 heldItem = player.method_6047();

        if (player.method_7325()) {
            MODE = Mode.IDLE;
            onReset(player);
            return;
        }

        if (!inLectern() && !heldItem.method_31574(AllItems.LINKED_CONTROLLER)) {
            heldItem = player.method_6079();
            if (!heldItem.method_31574(AllItems.LINKED_CONTROLLER)) {
                MODE = Mode.IDLE;
                onReset(player);
                return;
            }
        }

        if (inLectern() && AllBlocks.LECTERN_CONTROLLER.getBlockEntityOptional(world, lecternPos).map(be -> !be.isUsedBy(mc.field_1724)).orElse(true)) {
            deactivateInLectern(player);
            return;
        }

        if (mc.field_1755 != null) {
            MODE = Mode.IDLE;
            onReset(player);
            return;
        }

        if (class_3675.method_15987(mc.method_22683(), GLFW.GLFW_KEY_ESCAPE)) {
            MODE = Mode.IDLE;
            onReset(player);
            return;
        }

        List<class_304> controls = ControlsUtil.getControls();
        Collection<Integer> pressedKeys = new HashSet<>();
        for (int i = 0; i < controls.size(); i++) {
            if (ControlsUtil.isActuallyPressed(controls.get(i)))
                pressedKeys.add(i);
        }

        Collection<Integer> newKeys = new HashSet<>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);

        if (MODE == Mode.ACTIVE) {
            // Released Keys
            if (!releasedKeys.isEmpty()) {
                player.field_3944.method_52787(new LinkedControllerInputPacket(releasedKeys, false, lecternPos));
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.method_73183(), player.method_24515(), 1f, .5f, true);
            }

            // Newly Pressed Keys
            if (!newKeys.isEmpty()) {
                player.field_3944.method_52787(new LinkedControllerInputPacket(newKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.method_73183(), player.method_24515(), 1f, .75f, true);
            }

            // Keepalive Pressed Keys
            if (packetCooldown == 0) {
                if (!pressedKeys.isEmpty()) {
                    player.field_3944.method_52787(new LinkedControllerInputPacket(pressedKeys, true, lecternPos));
                    packetCooldown = PACKET_RATE;
                }
            }
        }

        if (MODE == Mode.BIND) {
            class_265 shape = world.method_8320(selectedLocation).method_26218(world, selectedLocation);
            if (!shape.method_1110())
                Outliner.getInstance().showAABB("controller", shape.method_1107().method_996(selectedLocation)).colored(0xB73C2D).lineWidth(1 / 16f);

            for (Integer integer : newKeys) {
                ServerLinkBehaviour linkBehaviour = BlockEntityBehaviour.get(world, selectedLocation, ServerLinkBehaviour.TYPE);
                if (linkBehaviour != null) {
                    player.field_3944.method_52787(new LinkedControllerBindPacket(integer, selectedLocation));
                    CreateLang.translate("linked_controller.key_bound", controls.get(integer).method_16007().getString())
                        .sendStatus(mc.field_1724);
                }
                MODE = Mode.IDLE;
                break;
            }
        }

        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.method_23481(false));
    }

    public static void renderOverlay(class_310 mc, class_332 guiGraphics) {
        if (MODE != Mode.BIND)
            return;
        int width1 = guiGraphics.method_51421();
        int height1 = guiGraphics.method_51443();

        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        poseStack.pushMatrix();

        Object[] keys = new Object[6];
        List<class_304> controls = ControlsUtil.getControls();
        for (int i = 0; i < controls.size(); i++) {
            class_304 keyBinding = controls.get(i);
            keys[i] = keyBinding.method_16007().getString();
        }

        List<class_2561> list = new ArrayList<>();
        list.add(CreateLang.translateDirect("linked_controller.bind_mode").method_27692(class_124.field_1065));
        list.addAll(TooltipHelper.cutTextComponent(CreateLang.translateDirect("linked_controller.press_keybind", keys), Palette.ALL_GRAY));

        int width = 0;
        int height = list.size() * mc.field_1772.field_2000;
        for (class_2561 iTextComponent : list)
            width = Math.max(width, mc.field_1772.method_27525(iTextComponent));
        int x = (width1 / 3) - width / 2;
        int y = height1 - height - 24;

        // TODO
        guiGraphics.method_51435(
            mc.field_1772,
            list.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList()),
            x,
            y,
            class_8001.field_41687,
            null
        );

        poseStack.popMatrix();
    }

    public enum Mode {
        IDLE,
        ACTIVE,
        BIND
    }

}
