package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3492;
import net.minecraft.class_5244;

public class SchematicEditScreen extends AbstractSimiScreen {

    private final List<class_2561> rotationOptions = CreateLang.translatedOptions("schematic.rotation", "none", "cw90", "cw180", "cw270");
    private final List<class_2561> mirrorOptions = CreateLang.translatedOptions("schematic.mirror", "none", "leftRight", "frontBack");
    private final class_2561 rotationLabel = CreateLang.translateDirect("schematic.rotation");
    private final class_2561 mirrorLabel = CreateLang.translateDirect("schematic.mirror");

    private AllGuiTextures background;

    private class_342 xInput;
    private class_342 yInput;
    private class_342 zInput;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    private ScrollInput rotationArea;
    private ScrollInput mirrorArea;
    private SchematicHandler handler;

    public SchematicEditScreen() {
        background = AllGuiTextures.SCHEMATIC;
        handler = Create.SCHEMATIC_HANDLER;
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight());
        setWindowOffset(-6, 0);
        super.method_25426();

        int x = guiLeft;
        int y = guiTop + 2;

        xInput = new class_342(field_22793, x + 50, y + 26, 34, 10, class_5244.field_39003);
        yInput = new class_342(field_22793, x + 90, y + 26, 34, 10, class_5244.field_39003);
        zInput = new class_342(field_22793, x + 130, y + 26, 34, 10, class_5244.field_39003);

        class_2338 anchor = handler.getTransformation().getAnchor();
        if (handler.isDeployed()) {
            xInput.method_1852("" + anchor.method_10263());
            yInput.method_1852("" + anchor.method_10264());
            zInput.method_1852("" + anchor.method_10260());
        } else {
            class_2338 alt = field_22787.field_1724.method_24515();
            xInput.method_1852("" + alt.method_10263());
            yInput.method_1852("" + alt.method_10264());
            zInput.method_1852("" + alt.method_10260());
        }

        for (class_342 widget : new class_342[]{xInput, yInput, zInput}) {
            widget.method_1880(6);
            widget.method_1858(false);
            widget.method_1868(0xFFFFFFFF);
            widget.method_25365(false);
            widget.method_25402(new class_11909(0, 0, new class_11910(0, 0)), false);
            widget.method_1890(s -> {
                if (s.isEmpty() || s.equals("-"))
                    return true;
                try {
                    Integer.parseInt(s);
                    return true;
                } catch (NumberFormatException e) {
                    return false;
                }
            });
        }

        class_3492 settings = handler.getTransformation().toSettings();
        Label labelR = new Label(x + 50, y + 48, class_5244.field_39003).withShadow();
        rotationArea = new SelectionScrollInput(x + 45, y + 43, 118, 18).forOptions(rotationOptions).titled(rotationLabel.method_27662())
            .setState(settings.method_15113().ordinal()).writingTo(labelR);

        Label labelM = new Label(x + 50, y + 70, class_5244.field_39003).withShadow();
        mirrorArea = new SelectionScrollInput(x + 45, y + 65, 118, 18).forOptions(mirrorOptions).titled(mirrorLabel.method_27662())
            .setState(settings.method_15114().ordinal()).writingTo(labelM);

        addRenderableWidgets(xInput, yInput, zInput);
        addRenderableWidgets(labelR, labelM, rotationArea, mirrorArea);

        confirmButton = new IconButton(x + background.getWidth() - 33, y + background.getHeight() - 26, AllIcons.I_CONFIRM);
        confirmButton.withCallback(this::method_25419);
        method_37063(confirmButton);

        renderedItem = new ElementWidget(
            x + background.getWidth() + 6,
            y + background.getHeight() - 40
        ).showingElement(GuiGameElement.of(AllItems.SCHEMATIC.method_7854()).scale(3));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (input.method_74243()) {
            String coords = field_22787.field_1774.method_1460();
            if (coords != null && !coords.isEmpty()) {
                coords.replaceAll(" ", "");
                String[] split = coords.split(",");
                if (split.length == 3) {
                    boolean valid = true;
                    for (String s : split) {
                        try {
                            Integer.parseInt(s);
                        } catch (NumberFormatException e) {
                            valid = false;
                        }
                    }
                    if (valid) {
                        xInput.method_1852(split[0]);
                        yInput.method_1852(split[1]);
                        zInput.method_1852(split[2]);
                        return true;
                    }
                }
            }
        }

        return super.method_25404(input);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        background.render(graphics, x, y);
        String title = handler.getCurrentSchematicName();
        graphics.method_51433(field_22793, title, x + (background.getWidth() - 8 - field_22793.method_1727(title)) / 2, y + 4, 0xFF505050, false);
    }

    @Override
    public void method_25432() {
        boolean validCoords = true;
        class_2338 newLocation = null;
        try {
            newLocation = new class_2338(Integer.parseInt(xInput.method_1882()), Integer.parseInt(yInput.method_1882()), Integer.parseInt(zInput.method_1882()));
        } catch (NumberFormatException e) {
            validCoords = false;
        }

        class_3492 settings = new class_3492();
        settings.method_15123(class_2470.values()[rotationArea.getState()]);
        settings.method_15125(class_2415.values()[mirrorArea.getState()]);

        if (validCoords && newLocation != null) {
            class_1799 item = handler.getActiveSchematicItem();
            if (item != null) {
                item.method_57379(AllDataComponents.SCHEMATIC_DEPLOYED, true);
                item.method_57379(AllDataComponents.SCHEMATIC_ANCHOR, newLocation);
            }

            handler.getTransformation().init(newLocation, settings, handler.getBounds());
            handler.markDirty();
            handler.deploy(field_22787);
        }
    }

}