package com.zurrtum.create.client.content.trains.bogey;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.content.trains.bogey.BogeyBlockEntityRenderer.BogeyRenderState;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class StandardBogeyRenderer implements BogeyRenderer {
    public static void updateRenderState(StandardBogeyRenderState data, float wheelAngle, int light) {
        data.layer = class_1921.method_23579();
        data.shaft = CachedBuffers.block(AllBlocks.SHAFT.method_9564().method_11657(ShaftBlock.AXIS, class_2350.class_2351.field_11051));
        data.angle = class_3532.field_29847 * wheelAngle;
        data.light = light;
        data.offset = -1.5 - 1 / 128f;
    }

    @Override
    public BogeyRenderState getRenderData(@Nullable class_2487 bogeyData, float wheelAngle, float tickProgress, int light, boolean inContraption) {
        StandardBogeyRenderState data = new StandardBogeyRenderState();
        updateRenderState(data, wheelAngle, light);
        return data;
    }

    public static class Small extends StandardBogeyRenderer {
        @Override
        public BogeyRenderState getRenderData(
            @Nullable class_2487 bogeyData,
            float wheelAngle,
            float tickProgress,
            int light,
            boolean inContraption
        ) {
            SmallBogeyRenderState data = new SmallBogeyRenderState();
            updateRenderState(data, wheelAngle, light);
            class_2680 air = class_2246.field_10124.method_9564();
            data.frame = CachedBuffers.partial(AllPartialModels.BOGEY_FRAME, air);
            data.wheels = CachedBuffers.partial(AllPartialModels.SMALL_BOGEY_WHEELS, air);
            return data;
        }
    }

    public static class Large extends StandardBogeyRenderer {
        public static final float BELT_RADIUS_PX = 5f;
        public static final float BELT_RADIUS_IN_UV_SPACE = BELT_RADIUS_PX / 16f;

        @Override
        public BogeyRenderState getRenderData(
            @Nullable class_2487 bogeyData,
            float wheelAngle,
            float tickProgress,
            int light,
            boolean inContraption
        ) {
            LargeBogeyRenderState data = new LargeBogeyRenderState();
            updateRenderState(data, wheelAngle, light);
            data.secondaryShaft = CachedBuffers.block(AllBlocks.SHAFT.method_9564().method_11657(ShaftBlock.AXIS, class_2350.class_2351.field_11048));
            class_2680 air = class_2246.field_10124.method_9564();
            data.drive = CachedBuffers.partial(AllPartialModels.BOGEY_DRIVE, air);
            data.belt = CachedBuffers.partial(AllPartialModels.BOGEY_DRIVE_BELT, air);
            float spriteSize = AllSpriteShifts.BOGEY_BELT.getTarget().method_4575() - AllSpriteShifts.BOGEY_BELT.getTarget().method_4593();
            float scroll = BELT_RADIUS_IN_UV_SPACE * class_3532.field_29847 * wheelAngle;
            scroll = scroll - class_3532.method_15375(scroll);
            data.scroll = scroll * spriteSize * 0.5f;
            data.piston = CachedBuffers.partial(AllPartialModels.BOGEY_PISTON, air);
            data.pistonOffset = (float) (1 / 4f * Math.sin(AngleHelper.rad(wheelAngle)));
            data.wheels = CachedBuffers.partial(AllPartialModels.LARGE_BOGEY_WHEELS, air);
            data.pin = CachedBuffers.partial(AllPartialModels.BOGEY_PIN, air);
            return data;
        }
    }
}
