package com.zurrtum.create.client.content.trains.schedule;

import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.zurrtum.create.catnip.data.IntAttached;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4717;

public class DestinationSuggestions extends class_4717 {

    private final class_342 textBox;
    private final List<IntAttached<String>> viableStations;
    private String previous = "<>";
    private final class_327 font;
    private boolean active;

    List<Suggestion> currentSuggestions;
    private final int yOffset;

    public DestinationSuggestions(
        class_310 pMinecraft,
        class_437 pScreen,
        class_342 pInput,
        class_327 pFont,
        List<IntAttached<String>> viableStations,
        boolean anchorToBottom,
        int yOffset
    ) {
        super(pMinecraft, pScreen, pInput, pFont, true, true, 0, 7, anchorToBottom, 0xee_303030);
        this.textBox = pInput;
        this.font = pFont;
        this.viableStations = viableStations;
        this.yOffset = yOffset;
        currentSuggestions = new ArrayList<>();
        active = false;
    }

    public void tick() {
        if (field_21612 == null)
            textBox.method_1887("");
        if (active == textBox.method_25370())
            return;
        active = textBox.method_25370();
        method_23934();
    }

    @Override
    public void method_23934() {
        if (textBox.method_1882().length() < textBox.method_1881())
            return;

        String trimmed = textBox.method_1882().substring(0, textBox.method_1881());

        if (!textBox.method_1866().isBlank())
            trimmed = trimmed.replace(textBox.method_1866(), "");

        final String value = trimmed;

        if (value.equals(previous))
            return;
        if (!active) {
            field_21612 = null;
            return;
        }

        previous = value;
        currentSuggestions = viableStations.stream()
            .filter(ia -> !ia.getValue().equals(value) && ia.getValue().toLowerCase().startsWith(value.toLowerCase()))
            .sorted((ia1, ia2) -> Integer.compare(ia1.getFirst(), ia2.getFirst())).map(IntAttached::getValue)
            .map(s -> new Suggestion(new StringRange(0, 1000), s)).toList();

        showSuggestions(false);
    }

    public void showSuggestions(boolean pNarrateFirstSuggestion) {
        if (currentSuggestions.isEmpty()) {
            field_21612 = null;
            return;
        }

        int width = 0;
        for (Suggestion suggestion : currentSuggestions)
            width = Math.max(width, font.method_1727(suggestion.getText()));
        int x = class_3532.method_15340(textBox.method_1889(0), 0, textBox.method_1889(0) + textBox.method_1859() - width);
        field_21612 = new class_4717.class_464(x, 72 + yOffset, width, currentSuggestions, false);
    }

    public boolean isEmpty() {
        return viableStations.isEmpty();
    }

}
