package com.zurrtum.create.client.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.zurrtum.create.content.trains.schedule.condition.CargoThresholdCondition.Ops;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class CargoThresholdConditionRender<T extends CargoThresholdCondition> implements IScheduleInput<T> {
    protected abstract class_2561 getUnit(T input);

    protected abstract class_1799 getIcon(T input);

    @Override
    public Pair<class_1799, class_2561> getSummary(T input) {
        return Pair.of(getIcon(input), class_2561.method_43470(input.getOperator().formatted + " " + input.getThreshold()).method_10852(getUnit(input)));
    }

    @Override
    public int slotsTargeted() {
        return 1;
    }

    @Override
    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of(
            CreateLang.translateDirect("schedule.condition.threshold.place_item"),
            CreateLang.translateDirect("schedule.condition.threshold.place_item_2").method_27692(class_124.field_1080),
            CreateLang.translateDirect("schedule.condition.threshold.place_item_3").method_27692(class_124.field_1080)
        );
    }

    public List<class_5250> getOpsOptions() {
        return Arrays.stream(Ops.values()).map(op -> CreateLang.translateDirect("schedule.condition.threshold." + Lang.asId(op.name()))).toList();
    }

    @Override
    public void initConfigurationWidgets(T input, ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(
            0, 24, (i, l) -> {
                i.forOptions(getOpsOptions()).titled(CreateLang.translateDirect("schedule.condition.threshold.train_holds", ""))
                    .format(state -> class_2561.method_43470(" " + Ops.values()[state].formatted));
            }, "Operator"
        );
        builder.addIntegerTextInput(
            29, 41, (e, t) -> {
            }, "Threshold"
        );
    }
}
