package com.zurrtum.create.client.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.schedule.destination.ChangeThrottleInstruction;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ChangeThrottleInstructionRender implements IScheduleInput<ChangeThrottleInstruction> {
    @Override
    public Pair<class_1799, class_2561> getSummary(ChangeThrottleInstruction input) {
        return Pair.of(icon(), formatted(input));
    }

    private class_5250 formatted(ChangeThrottleInstruction input) {
        return class_2561.method_43470(input.intData("Value") + "%");
    }

    @Override
    public class_1799 getSecondLineIcon() {
        return icon();
    }

    @Override
    public List<class_2561> getTitleAs(ChangeThrottleInstruction input, String type) {
        return ImmutableList.of(CreateLang.translateDirect(
            "schedule." + type + "." + input.getId().method_12832() + ".summary",
            formatted(input).method_27692(class_124.field_1068)
        ).method_27692(class_124.field_1065));
    }

    public void initConfigurationWidgets(ChangeThrottleInstruction input, ModularGuiLineBuilder builder) {
        builder.addScrollInput(
            0, 50, (si, l) -> {
                si.withRange(5, 101).withStepFunction(c -> c.shift ? 25 : 5)
                    .titled(CreateLang.translateDirect("schedule.instruction.throttle_edit_box"));
                l.withSuffix("%");
            }, "Value"
        );
    }

    private class_1799 icon() {
        return AllItems.TRAIN_CONTROLS.method_7854();
    }

    @Override
    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of(
            CreateLang.translateDirect("schedule.instruction.throttle_edit_box"),
            CreateLang.translateDirect("schedule.instruction.throttle_edit_box_1").method_27692(class_124.field_1080)
        );
    }
}
