package com.zurrtum.create.client.flywheel.backend.engine;

import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.flywheel.backend.Samplers;
import net.minecraft.class_1044;
import net.minecraft.class_10868;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL12;

public class TextureBinder {
    public static void bind(class_2960 resourceLocation) {
        GlStateManager._bindTexture(byName(resourceLocation));
    }

    public static void bindCrumbling(class_2960 resourceLocation) {
        Samplers.CRUMBLING.makeActive();
        class_1044 texture = class_310.method_1551().method_1531().method_4619(resourceLocation);
        setupTexture(texture.method_71659());
    }

    public static void bindLightAndOverlay() {
        var gameRenderer = class_310.method_1551().field_1773;

        Samplers.OVERLAY.makeActive();
        gameRenderer.method_22975().method_23209();
        setupTexture(RenderSystem.getShaderTexture(1));

        Samplers.LIGHT.makeActive();
        gameRenderer.method_22974().method_3316();
        setupTexture(RenderSystem.getShaderTexture(2));
    }

    private static void setupTexture(@Nullable GpuTextureView textureView) {
        if (textureView == null) {
            return;
        }
        class_10868 texture = (class_10868) textureView.texture();
        GlStateManager._bindTexture(texture.method_68427());
        GlStateManager._texParameter(GlConst.GL_TEXTURE_2D, GL12.GL_TEXTURE_BASE_LEVEL, textureView.baseMipLevel());
        GlStateManager._texParameter(GlConst.GL_TEXTURE_2D, GL12.GL_TEXTURE_MAX_LEVEL, textureView.baseMipLevel() + textureView.mipLevels() - 1);
        texture.method_68424(GlConst.GL_TEXTURE_2D);
    }

    public static void resetLightAndOverlay() {
        var gameRenderer = class_310.method_1551().field_1773;

        gameRenderer.method_22975().method_23213();
        gameRenderer.method_22974().method_3315();
    }

    /**
     * Get a built-in texture by its resource location.
     *
     * @param texture The texture's resource location.
     * @return The texture.
     */
    public static int byName(class_2960 texture) {
        return ((class_10868) class_310.method_1551().method_1531().method_4619(texture).method_68004()).method_68427();
    }
}
