package com.zurrtum.create.client.flywheel.lib.backend;

import com.zurrtum.create.client.flywheel.api.backend.Backend;
import com.zurrtum.create.client.flywheel.api.backend.Engine;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import net.minecraft.class_1936;
import net.minecraft.class_2960;

public final class SimpleBackend implements Backend {
    private final Function<class_1936, Engine> engineFactory;
    private final IntSupplier priority;
    private final BooleanSupplier isSupported;

    public SimpleBackend(Function<class_1936, Engine> engineFactory, IntSupplier priority, BooleanSupplier isSupported) {
        this.engineFactory = engineFactory;
        this.priority = priority;
        this.isSupported = isSupported;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Engine createEngine(class_1936 level) {
        return this.engineFactory.apply(level);
    }

    public int priority() {
        return this.priority.getAsInt();
    }

    public boolean isSupported() {
        return this.isSupported.getAsBoolean();
    }

    public static final class Builder {
        private @Nullable Function<class_1936, Engine> engineFactory;
        private IntSupplier priority = () -> 0;
        private @Nullable BooleanSupplier isSupported;

        public Builder() {
        }

        public Builder engineFactory(Function<class_1936, Engine> engineFactory) {
            this.engineFactory = engineFactory;
            return this;
        }

        public Builder priority(int priority) {
            return this.priority(() -> priority);
        }

        public Builder priority(IntSupplier priority) {
            this.priority = priority;
            return this;
        }

        public Builder supported(BooleanSupplier isSupported) {
            this.isSupported = isSupported;
            return this;
        }

        public Backend register(class_2960 id) {
            Objects.requireNonNull(this.engineFactory);
            Objects.requireNonNull(this.isSupported);
            return Backend.REGISTRY.registerAndGet(id, new SimpleBackend(this.engineFactory, this.priority, this.isSupported));
        }
    }
}
