package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.lib.internal.FlwLibXplat;
import com.zurrtum.create.client.flywheel.lib.model.ModelUtil;
import com.zurrtum.create.client.flywheel.lib.model.SimpleModel;
import org.jetbrains.annotations.Nullable;

import java.util.function.BiFunction;
import net.minecraft.class_10801;
import net.minecraft.class_1087;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_4587;

public final class BakedModelBuilder {
    final class_1087 model;
    final class_10801 bakedModel;
    @Nullable class_1920 level;
    @Nullable class_2338 pos;
    @Nullable class_4587 poseStack;
    @Nullable BiFunction<class_11515, Boolean, Material> materialFunc;

    public BakedModelBuilder(class_10801 bakedModel) {
        this.bakedModel = bakedModel;
        this.model = null;
    }

    public BakedModelBuilder(class_1087 model) {
        this.model = model;
        this.bakedModel = null;
    }

    public BakedModelBuilder level(@Nullable class_1920 level) {
        this.level = level;
        return this;
    }

    public BakedModelBuilder pos(@Nullable class_2338 pos) {
        this.pos = pos;
        return this;
    }

    public BakedModelBuilder poseStack(@Nullable class_4587 poseStack) {
        this.poseStack = poseStack;
        return this;
    }

    public BakedModelBuilder materialFunc(@Nullable BiFunction<class_11515, Boolean, Material> materialFunc) {
        this.materialFunc = materialFunc;
        return this;
    }

    public SimpleModel build() {
        if (level == null) {
            level = EmptyVirtualBlockGetter.FULL_DARK;
        }
        if (pos == null) {
            pos = class_2338.field_10980;
        }
        if (materialFunc == null) {
            materialFunc = ModelUtil::getMaterial;
        }

        return FlwLibXplat.INSTANCE.buildBakedModelBuilder(this);
    }
}