package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.lib.memory.MemoryBlock;
import com.zurrtum.create.client.flywheel.lib.model.SimpleQuadMesh;
import com.zurrtum.create.client.flywheel.lib.vertex.FullVertexView;
import org.jetbrains.annotations.UnknownNullability;
import org.joml.Matrix4f;
import org.joml.Vector3f;

import java.util.function.BiConsumer;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import net.minecraft.class_777;
import net.minecraft.class_9799;
import net.minecraft.class_9848;

public class ItemMeshEmitter implements class_4588 {
    private final class_1921 renderType;
    private final class_9799 byteBufferBuilder;
    @UnknownNullability
    private class_287 bufferBuilder;

    private BakedItemModelBufferer.ResultConsumer resultConsumer;
    private BiConsumer<class_1921, Mesh> meshResultConsumer;
    private boolean currentShade;
    private boolean ended = true;

    ItemMeshEmitter(class_1921 renderType) {
        this.renderType = renderType;
        this.byteBufferBuilder = new class_9799(renderType.method_22722());
    }

    public void prepare(BakedItemModelBufferer.ResultConsumer resultConsumer, BiConsumer<class_1921, Mesh> meshResultConsumer) {
        this.resultConsumer = resultConsumer;
        this.meshResultConsumer = meshResultConsumer;
        ended = false;
    }

    public boolean isEnd() {
        return ended;
    }

    public void end() {
        if (ended) {
            return;
        }
        if (bufferBuilder != null) {
            emit();
        }
        resultConsumer = null;
        meshResultConsumer = null;
        ended = true;
    }

    public class_287 unwrap(boolean shade) {
        prepareForGeometry(shade);
        return bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (bufferBuilder == null) {
            bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1590);
        } else if (shade != currentShade) {
            emit();
            bufferBuilder = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1590);
        }

        currentShade = shade;
    }

    private void prepareForGeometry(class_777 quad) {
        prepareForGeometry(quad.comp_3725());
    }

    private void emit() {
        var data = bufferBuilder.method_60794();
        bufferBuilder = null;

        if (data != null) {
            resultConsumer.accept(renderType, currentShade, data);
            data.close();
        }
    }

    public void emit(class_630 part, class_4587 stack, class_1058 meshSprite, ItemMeshEmitter glintEmitter, int light, int overlay, int color) {
        stack.method_22903();
        part.method_22703(stack);
        if (!part.method_32087()) {
            Mesh mesh = compile(part, stack, meshSprite, light, overlay, color);
            meshResultConsumer.accept(renderType, mesh);
            if (glintEmitter != null) {
                glintEmitter.meshResultConsumer.accept(glintEmitter.renderType, mesh);
            }
        }
        for (class_630 child : part.field_3661.values()) {
            emit(child, stack, meshSprite, glintEmitter, light, overlay, color);
        }
        stack.method_22909();
    }

    private Mesh compile(class_630 part, class_4587 stack, class_1058 meshSprite, int light, int overlay, int color) {
        int vertexCount = 0;
        for (class_630.class_628 cuboid : part.field_3663) {
            vertexCount += cuboid.field_3649.length * 4;
        }
        MemoryBlock memoryBlock = MemoryBlock.mallocTracked(vertexCount * FullVertexView.STRIDE);
        FullVertexView meshVertices = new FullVertexView();

        meshVertices.nativeMemoryOwner(memoryBlock);
        meshVertices.ptr(memoryBlock.ptr());
        meshVertices.vertexCount(vertexCount);

        class_4587.class_4665 entry = stack.method_23760();
        Matrix4f matrix4f = entry.method_23761();
        Vector3f vector3f = new Vector3f();
        int index = 0;
        float red = class_9848.method_65101(color);
        float green = class_9848.method_65102(color);
        float blue = class_9848.method_65103(color);
        float alpha = class_9848.method_65100(color);
        boolean hasUV = meshSprite != null;
        for (class_630.class_628 cuboid : part.field_3663) {
            for (class_630.class_593 quad : cuboid.field_3649) {
                Vector3f normal = entry.method_56821(quad.comp_3185(), vector3f);
                float x = normal.x();
                float y = normal.y();
                float z = normal.z();
                for (class_630.class_618 vertex : quad.comp_3184()) {
                    float u = vertex.comp_3187();
                    float v = vertex.comp_3188();
                    if (hasUV) {
                        u = meshSprite.method_4580(u);
                        v = meshSprite.method_4570(v);
                    }
                    Vector3f position = matrix4f.transformPosition(vertex.comp_4804() / 16.0F, vertex.comp_4805() / 16.0F, vertex.comp_4806() / 16.0F, vector3f);
                    meshVertices.x(index, position.x());
                    meshVertices.y(index, position.y());
                    meshVertices.z(index, position.z());
                    meshVertices.r(index, red);
                    meshVertices.g(index, green);
                    meshVertices.b(index, blue);
                    meshVertices.a(index, alpha);
                    meshVertices.u(index, u);
                    meshVertices.v(index, v);
                    meshVertices.overlay(index, overlay);
                    meshVertices.light(index, light);
                    meshVertices.normalX(index, x);
                    meshVertices.normalY(index, y);
                    meshVertices.normalZ(index, z);
                    index++;
                }
            }
        }

        return new SimpleQuadMesh(meshVertices, "source=ItemMeshEmitter");
    }

    public void quad(
        class_4587.class_4665 pose,
        class_777 quad,
        float red,
        float green,
        float blue,
        float alpha,
        int light,
        int overlay,
        boolean readExistingColor
    ) {
        prepareForGeometry(quad);
        bufferBuilder.method_22920(
            pose,
            quad,
            new float[]{1.0F, 1.0F, 1.0F, 1.0F},
            red,
            green,
            blue,
            alpha,
            new int[]{light, light, light, light},
            overlay,
            readExistingColor
        );
    }

    @Override
    public void method_22919(class_4587.class_4665 pose, class_777 quad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        prepareForGeometry(quad);
        bufferBuilder.method_22919(pose, quad, red, green, blue, alpha, packedLight, packedOverlay);
    }

    @Override
    public void method_22920(
        class_4587.class_4665 pose,
        class_777 quad,
        float[] brightnesses,
        float red,
        float green,
        float blue,
        float alpha,
        int[] lights,
        int overlay,
        boolean readExistingColor
    ) {
        prepareForGeometry(quad);
        bufferBuilder.method_22920(pose, quad, brightnesses, red, green, blue, alpha, lights, overlay, readExistingColor);
    }

    @Override
    public class_4588 method_22912(float x, float y, float z) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_1336(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22913(float u, float v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_60796(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22921(int u, int v) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }

    @Override
    public class_4588 method_22914(float normalX, float normalY, float normalZ) {
        throw new UnsupportedOperationException("MeshEmitter only supports putBulkData!");
    }
}
