package com.zurrtum.create.client.flywheel.lib.transform;

import net.minecraft.class_4587;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

/**
 * A wrapper around {@link class_4587} that implements {@link TransformStack}.
 * <br>
 * Only one instance of this class should exist per {@link class_4587}.
 */
public final class PoseTransformStack implements TransformStack<PoseTransformStack> {
    private final class_4587 stack;

    /**
     * Use {@link TransformStack#of(class_4587)}.
     */
    @ApiStatus.Internal
    public PoseTransformStack(class_4587 stack) {
        this.stack = stack;
    }

    @Override
    public PoseTransformStack pushPose() {
        stack.method_22903();
        return this;
    }

    @Override
    public PoseTransformStack popPose() {
        stack.method_22909();
        return this;
    }

    @Override
    public PoseTransformStack mulPose(Matrix4fc pose) {
        stack.method_23760().method_23761().mul(pose);
        return this;
    }

    @Override
    public PoseTransformStack mulNormal(Matrix3fc normal) {
        stack.method_23760().method_23762().mul(normal);
        return this;
    }

    @Override
    public PoseTransformStack rotateAround(Quaternionfc quaternion, float x, float y, float z) {
        class_4587.class_4665 pose = stack.method_23760();
        pose.method_23761().rotateAround(quaternion, x, y, z);
        pose.method_23762().rotate(quaternion);
        return this;
    }

    @Override
    public PoseTransformStack translate(float x, float y, float z) {
        stack.method_46416(x, y, z);
        return this;
    }

    @Override
    public PoseTransformStack rotate(Quaternionfc quaternion) {
        class_4587.class_4665 pose = stack.method_23760();
        pose.method_23761().rotate(quaternion);
        pose.method_23762().rotate(quaternion);
        return this;
    }

    @Override
    public PoseTransformStack scale(float factorX, float factorY, float factorZ) {
        stack.method_22905(factorX, factorY, factorZ);
        return this;
    }

    public class_4587 unwrap() {
        return stack;
    }
}
