package com.zurrtum.create.client.flywheel.lib.transform;

import net.minecraft.class_4587;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public interface Transform<Self extends Transform<Self>> extends Affine<Self> {
    Self mulPose(Matrix4fc pose);

    Self mulNormal(Matrix3fc normal);

    default Self transform(Matrix4fc pose, Matrix3fc normal) {
        return mulPose(pose).mulNormal(normal);
    }

    default Self transform(class_4587.class_4665 pose) {
        return transform(pose.method_23761(), pose.method_23762());
    }

    default Self transform(class_4587 stack) {
        return transform(stack.method_23760());
    }
}
