package com.zurrtum.create.client.foundation.blockEntity;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsInputHandler;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.ValueSettingsPacket;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class ValueSettingsClient {
    public int interactHeldTicks = -1;
    public class_2338 interactHeldPos = null;
    public BehaviourType<? extends BlockEntityBehaviour<?>> interactHeldBehaviour = null;
    public class_1268 interactHeldHand = null;
    public class_2350 interactHeldFace = null;

    public List<class_5250> lastHoverTip;
    public int hoverTicks;
    public int hoverWarmup;

    public boolean cancelIfWarmupAlreadyStarted(class_2338 pos) {
        return interactHeldTicks != -1 && pos.equals(interactHeldPos);
    }

    public void startInteractionWith(class_2338 pos, BehaviourType<? extends BlockEntityBehaviour<?>> behaviourType, class_1268 hand, class_2350 side) {
        interactHeldTicks = 0;
        interactHeldPos = pos;
        interactHeldBehaviour = behaviourType;
        interactHeldHand = hand;
        interactHeldFace = side;
    }

    public void cancelInteraction() {
        interactHeldTicks = -1;
    }

    public void tick(class_310 mc) {
        if (hoverWarmup > 0)
            hoverWarmup--;
        if (hoverTicks > 0)
            hoverTicks--;
        if (interactHeldTicks == -1)
            return;
        class_746 player = mc.field_1724;

        if (!ValueSettingsInputHandler.canInteract(player) || player.method_6047().method_31574(AllItems.CLIPBOARD)) {
            cancelInteraction();
            return;
        }
        class_239 hitResult = mc.field_1765;
        if (!(hitResult instanceof class_3965 blockHitResult) || !blockHitResult.method_17777().equals(interactHeldPos)) {
            cancelInteraction();
            return;
        }
        BlockEntityBehaviour<?> behaviour = BlockEntityBehaviour.get(mc.field_1687, interactHeldPos, interactHeldBehaviour);
        if (!(behaviour instanceof ValueSettingsBehaviour valueSettingBehaviour) || valueSettingBehaviour.bypassesInput(player.method_6047()) || !valueSettingBehaviour.testHit(
            blockHitResult.method_17784())) {
            cancelInteraction();
            return;
        }
        if (!mc.field_1690.field_1904.method_1434()) {
            player.field_3944.method_52787(new ValueSettingsPacket(
                interactHeldPos,
                0,
                0,
                interactHeldHand,
                blockHitResult,
                interactHeldFace,
                false,
                valueSettingBehaviour.netId()
            ));
            valueSettingBehaviour.onShortInteract(player, interactHeldHand, interactHeldFace, blockHitResult);
            cancelInteraction();
            return;
        }

        if (interactHeldTicks > 3)
            player.field_6252 = false;
        if (interactHeldTicks++ < 5)
            return;
        ScreenOpener.open(new ValueSettingsScreen(
            interactHeldPos,
            valueSettingBehaviour.createBoard(player, blockHitResult),
            valueSettingBehaviour.getValueSettings(),
            valueSettingBehaviour::newSettingHovered,
            valueSettingBehaviour.netId()
        ));
        interactHeldTicks = -1;
    }

    public void showHoverTip(class_310 mc, List<class_5250> tip) {
        if (mc.field_1755 != null)
            return;
        if (hoverWarmup < 6) {
            hoverWarmup += 2;
            return;
        } else
            hoverWarmup++;
        hoverTicks = hoverTicks == 0 ? 11 : Math.max(hoverTicks, 6);
        lastHoverTip = tip;
    }

    public void render(class_310 mc, class_332 guiGraphics) {
        if (!ValueSettingsInputHandler.canInteract(mc.field_1724))
            return;
        if (hoverTicks == 0 || lastHoverTip == null)
            return;

        int x = guiGraphics.method_51421() / 2;
        int y = guiGraphics.method_51443() - 75 - lastHoverTip.size() * 12;
        float alpha = hoverTicks > 5 ? (11 - hoverTicks) / 5f : Math.min(1, hoverTicks / 5f);

        Color color = new Color(0xffffff);
        Color titleColor = new Color(0xFBDC7D);
        color.setAlpha(alpha);
        titleColor.setAlpha(alpha);

        for (int i = 0; i < lastHoverTip.size(); i++) {
            class_5250 mutableComponent = lastHoverTip.get(i);
            guiGraphics.method_51439(
                mc.field_1772,
                mutableComponent,
                x - mc.field_1772.method_27525(mutableComponent) / 2,
                y,
                (i == 0 ? titleColor : color).getRGB(),
                true
            );
            y += 12;
        }
    }

}
