package com.zurrtum.create.client.foundation.blockEntity;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsFormatter.ScrollOptionSettingsFormatter;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.foundation.blockEntity.behaviour.ValueSettings;
import com.zurrtum.create.infrastructure.packet.c2s.ValueSettingsPacket;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ValueSettingsScreen extends AbstractSimiScreen {

    private int ticksOpen;
    private ValueSettingsBoard board;
    private int maxLabelWidth;
    private int valueBarWidth;
    private class_2338 pos;
    private ValueSettings initialSettings;
    private ValueSettings lastHovered = new ValueSettings(-1, -1);
    private Consumer<ValueSettings> onHover;
    private boolean iconMode;
    private int milestoneSize;
    private int soundCoolDown;
    private int netId;

    public ValueSettingsScreen(class_2338 pos, ValueSettingsBoard board, ValueSettings valueSettings, Consumer<ValueSettings> onHover, int netId) {
        this.pos = pos;
        this.board = board;
        this.initialSettings = valueSettings;
        this.onHover = onHover;
        this.netId = netId;
        this.iconMode = board.formatter() instanceof ScrollOptionSettingsFormatter;
        this.milestoneSize = iconMode ? 8 : 4;
    }

    @Override
    protected void method_25426() {
        int maxValue = board.maxValue();
        maxLabelWidth = 0;
        int milestoneCount = maxValue / board.milestoneInterval() + 1;
        int scale = maxValue > 128 ? 1 : 2;

        for (class_2561 component : board.rows())
            maxLabelWidth = Math.max(maxLabelWidth, field_22793.method_27525(component));
        if (iconMode)
            maxLabelWidth = -18;

        valueBarWidth = (maxValue + 1) * scale + 1 + milestoneCount * milestoneSize;
        int width = (maxLabelWidth + 14) + (valueBarWidth + 10);
        int height = (board.rows().size() * 11);

        setWindowSize(width, height);
        super.method_25426();

        class_241 coordinateOfValue = getCoordinateOfValue(initialSettings.row(), initialSettings.value());
        setCursor(coordinateOfValue);
    }

    private void setCursor(class_241 coordinateOfValue) {
        double guiScale = field_22787.method_22683().method_4495();
        GLFW.glfwSetCursorPos(field_22787.method_22683().method_4490(), coordinateOfValue.field_1343 * guiScale, coordinateOfValue.field_1342 * guiScale);
    }

    public ValueSettings getClosestCoordinate(int mouseX, int mouseY) {
        int row = 0;
        int column = 0;
        boolean milestonesOnly = AllKeys.hasShiftDown();

        double bestDiff = Double.MAX_VALUE;
        for (; row < board.rows().size(); row++) {
            class_241 coord = getCoordinateOfValue(row, 0);
            double diff = Math.abs(coord.field_1342 - mouseY);
            if (bestDiff < diff)
                break;
            bestDiff = diff;
        }
        row -= 1;

        bestDiff = Double.MAX_VALUE;
        for (; column <= board.maxValue(); column++) {
            class_241 coord = getCoordinateOfValue(row, milestonesOnly ? column * board.milestoneInterval() : column);
            double diff = Math.abs(coord.field_1343 - mouseX);
            if (bestDiff < diff)
                break;
            bestDiff = diff;
        }
        column -= 1;

        return new ValueSettings(row, milestonesOnly ? Math.min(column * board.milestoneInterval(), board.maxValue()) : column);
    }

    public class_241 getCoordinateOfValue(int row, int column) {
        int scale = board.maxValue() > 128 ? 1 : 2;
        float xOut = guiLeft + ((Math.max(1, column) - 1) / board.milestoneInterval()) * milestoneSize + column * scale + 1.5f;
        xOut += maxLabelWidth + 14 + 4;

        if (column % board.milestoneInterval() == 0)
            xOut += milestoneSize / 2;
        if (column > 0)
            xOut += milestoneSize;

        float yOut = guiTop + (row + .5f) * 11 - .5f;
        return new class_241(xOut, yOut);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;
        int milestoneCount = board.maxValue() / board.milestoneInterval() + 1;
        int scale = board.maxValue() > 128 ? 1 : 2;

        class_2561 title = board.title();
        class_2561 tip = CreateLang.translateDirect("gui.value_settings.release_to_confirm", class_2561.method_43472("key.use"));
        double fadeIn = Math.pow(class_3532.method_15350((ticksOpen + partialTicks) / 4.0, 0, 1), 1);

        int fattestLabel = Math.max(field_22793.method_27525(tip), field_22793.method_27525(title));
        if (iconMode)
            for (int i = 0; i <= board.maxValue(); i++)
                fattestLabel = Math.max(fattestLabel, field_22793.method_27525(board.formatter().format(new ValueSettings(0, i))));

        int fatTipOffset = Math.max(0, fattestLabel + 10 - (windowWidth + 13)) / 2;
        int bgWidth = Math.max((windowWidth + 13), fattestLabel + 10);
        int fadeInWidth = (int) (bgWidth * fadeIn);
        int fadeInStart = (bgWidth - fadeInWidth) / 2 - fatTipOffset;
        int additionalHeight = iconMode ? 46 : 33;

        UIRenderHelper.drawStretched(
            graphics,
            x - 11 + fadeInStart,
            y - 17,
            fadeInWidth,
            windowHeight + additionalHeight,
            AllGuiTextures.VALUE_SETTINGS_OUTER_BG
        );
        UIRenderHelper.drawStretched(graphics, x - 10 + fadeInStart, y - 18, fadeInWidth - 2, 1, AllGuiTextures.VALUE_SETTINGS_OUTER_BG);
        UIRenderHelper.drawStretched(
            graphics,
            x - 10 + fadeInStart,
            y - 17 + windowHeight + additionalHeight,
            fadeInWidth - 2,
            1,
            AllGuiTextures.VALUE_SETTINGS_OUTER_BG
        );

        if (fadeInWidth > fattestLabel) {
            int textX = x - 11 - fatTipOffset + bgWidth / 2;
            graphics.method_51439(field_22793, title, textX - field_22793.method_27525(title) / 2, y - 14, 0xffdddddd, false);
            graphics.method_51439(field_22793, tip, textX - field_22793.method_27525(tip) / 2, y + windowHeight + additionalHeight - 27, 0xffdddddd, false);
        }

        renderBrassFrame(graphics, x + maxLabelWidth + 14, y - 3, valueBarWidth + 8, board.rows().size() * 11 + 5);
        UIRenderHelper.drawStretched(
            graphics,
            x + maxLabelWidth + 17,
            y,
            valueBarWidth + 2,
            board.rows().size() * 11 - 1,
            AllGuiTextures.VALUE_SETTINGS_BAR_BG
        );

        int originalY = y;
        for (class_2561 component : board.rows()) {
            int valueBarX = x + maxLabelWidth + 14 + 4;

            if (!iconMode) {
                UIRenderHelper.drawCropped(graphics, x - 4, y, maxLabelWidth + 8, 11, AllGuiTextures.VALUE_SETTINGS_LABEL_BG);
                for (int w = 0; w < valueBarWidth; w += AllGuiTextures.VALUE_SETTINGS_BAR.getWidth() - 1)
                    UIRenderHelper.drawCropped(
                        graphics,
                        valueBarX + w,
                        y + 1,
                        Math.min(AllGuiTextures.VALUE_SETTINGS_BAR.getWidth() - 1, valueBarWidth - w),
                        8,
                        AllGuiTextures.VALUE_SETTINGS_BAR
                    );
                graphics.method_51439(field_22793, component, x, y + 1, 0xFF442000, false);
            }

            int milestoneX = valueBarX;
            for (int milestone = 0; milestone < milestoneCount; milestone++) {
                if (iconMode)
                    AllGuiTextures.VALUE_SETTINGS_WIDE_MILESTONE.render(graphics, milestoneX, y + 1);
                else
                    AllGuiTextures.VALUE_SETTINGS_MILESTONE.render(graphics, milestoneX, y + 1);
                milestoneX += milestoneSize + board.milestoneInterval() * scale;
            }

            y += 11;
        }

        if (!iconMode)
            renderBrassFrame(graphics, x - 7, originalY - 3, maxLabelWidth + 14, board.rows().size() * 11 + 5);

        if (ticksOpen < 1)
            return;

        ValueSettings closest = getClosestCoordinate(mouseX, mouseY);

        if (!closest.equals(lastHovered)) {
            onHover.accept(closest);
            if (soundCoolDown == 0) {
                float pitch = (closest.value()) / (float) (board.maxValue());
                pitch = class_3532.method_16439(pitch, 1.15f, 1.5f);
                field_22787.method_1483().method_4873(class_1109.method_4757(AllSoundEvents.SCROLL_VALUE.getMainEvent(), pitch, 0.25F));
                ScrollValueHandler.wrenchCog.bump(3, -(closest.value() - lastHovered.value()) * 10);
                soundCoolDown = 1;
            }
        }
        lastHovered = closest;

        class_241 coordinate = getCoordinateOfValue(closest.row(), closest.value());
        class_2561 cursorText = board.formatter().format(closest);

        AllIcons cursorIcon = null;
        if (board.formatter() instanceof ScrollOptionSettingsFormatter sosf)
            cursorIcon = sosf.getIcon(closest);

        int cursorWidth = ((cursorIcon != null ? 16 : field_22793.method_27525(cursorText)) / 2) * 2 + 3;
        int cursorX = ((int) (coordinate.field_1343)) - cursorWidth / 2;
        int cursorY = ((int) (coordinate.field_1342)) - 7;

        if (cursorIcon != null) {
            AllGuiTextures.VALUE_SETTINGS_CURSOR_ICON.render(graphics, cursorX - 2, cursorY - 3);
            cursorIcon.render(graphics, cursorX + 1, cursorY - 1, 0xFF431F00);
            if (fadeInWidth > fattestLabel)
                graphics.method_51439(
                    field_22793,
                    cursorText,
                    x - 11 - fatTipOffset + (bgWidth - field_22793.method_27525(cursorText)) / 2,
                    originalY + windowHeight + additionalHeight - 40,
                    0xFFFBDC7D,
                    false
                );
            return;
        }

        AllGuiTextures.VALUE_SETTINGS_CURSOR_LEFT.render(graphics, cursorX - 3, cursorY);
        UIRenderHelper.drawCropped(graphics, cursorX, cursorY, cursorWidth, 14, AllGuiTextures.VALUE_SETTINGS_CURSOR);
        AllGuiTextures.VALUE_SETTINGS_CURSOR_RIGHT.render(graphics, cursorX + cursorWidth, cursorY);

        graphics.method_51439(field_22793, cursorText, cursorX + 2, cursorY + 3, 0xFF442000, false);
    }

    protected void renderBrassFrame(class_332 graphics, int x, int y, int w, int h) {
        AllGuiTextures.BRASS_FRAME_TL.render(graphics, x, y);
        AllGuiTextures.BRASS_FRAME_TR.render(graphics, x + w - 4, y);
        AllGuiTextures.BRASS_FRAME_BL.render(graphics, x, y + h - 4);
        AllGuiTextures.BRASS_FRAME_BR.render(graphics, x + w - 4, y + h - 4);

        if (h > 8) {
            UIRenderHelper.drawStretched(graphics, x, y + 4, 3, h - 8, AllGuiTextures.BRASS_FRAME_LEFT);
            UIRenderHelper.drawStretched(graphics, x + w - 3, y + 4, 3, h - 8, AllGuiTextures.BRASS_FRAME_RIGHT);
        }

        if (w > 8) {
            UIRenderHelper.drawCropped(graphics, x + 4, y, w - 8, 3, AllGuiTextures.BRASS_FRAME_TOP);
            UIRenderHelper.drawCropped(graphics, x + 4, y + h - 3, w - 8, 3, AllGuiTextures.BRASS_FRAME_BOTTOM);
        }

    }

    @Override
    public void method_25420(@NotNull class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int a = ((int) (0x50 * Math.min(1, (ticksOpen + pPartialTick) / 20f))) << 24;
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, 0x101010 | a, 0x101010 | a);
    }

    @Override
    public void method_25393() {
        ticksOpen++;
        if (soundCoolDown > 0)
            soundCoolDown--;
        super.method_25393();
    }

    @Override
    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        ValueSettings closest = getClosestCoordinate((int) pMouseX, (int) pMouseY);
        int column = closest.value() + ((int) Math.signum(pScrollY)) * (AllKeys.hasShiftDown() ? board.milestoneInterval() : 1);
        column = class_3532.method_15340(column, 0, board.maxValue());
        if (column == closest.value())
            return false;
        setCursor(getCoordinateOfValue(closest.row(), column));
        return true;
    }

    @Override
    public boolean method_16803(class_11908 input) {
        if (field_22787.field_1690.field_1904.method_1417(input)) {
            class_1041 window = field_22787.method_22683();
            double x = field_22787.field_1729.method_1603() * window.method_4486() / window.method_4480();
            double y = field_22787.field_1729.method_1604() * window.method_4502() / window.method_4507();
            saveAndClose(x, y);
            return true;
        }
        return super.method_16803(input);
    }

    @Override
    public boolean method_25406(class_11909 click) {
        if (field_22787.field_1690.field_1904.method_1433(click)) {
            saveAndClose(click.comp_4798(), click.comp_4799());
            return true;
        }
        return super.method_25406(click);
    }

    protected void saveAndClose(double pMouseX, double pMouseY) {
        ValueSettings closest = getClosestCoordinate((int) pMouseX, (int) pMouseY);
        field_22787.field_1724.field_3944.method_52787(new ValueSettingsPacket(
            pos,
            closest.row(),
            closest.value(),
            null,
            null,
            class_2350.field_11036,
            AllKeys.hasControlDown(),
            netId
        ));
        method_25419();
    }

    @Override
    public void method_25419() {
        super.method_25419();
    }

}
