package com.zurrtum.create.client.foundation.blockEntity.behaviour.audio;

import com.zurrtum.create.AllParticleTypes;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.decoration.steamWhistle.WhistleSoundInstance;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock.WhistleSize;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class WhistleAudioBehaviour extends AudioBehaviour<WhistleBlockEntity> {
    protected WhistleSoundInstance soundInstance;

    public WhistleAudioBehaviour(WhistleBlockEntity be) {
        super(be);
    }

    @Override
    public void tickAudio() {
        FluidTankBlockEntity tank = blockEntity.getTank();
        boolean powered = blockEntity.isPowered() && (tank != null && tank.boiler.isActive() && (tank.boiler.passiveHeat || tank.boiler.activeHeat > 0) || blockEntity.isVirtual());
        if (!powered) {
            if (soundInstance != null) {
                soundInstance.fadeOut();
                soundInstance = null;
            }
            return;
        }

        class_1937 world = blockEntity.method_10997();
        class_2338 pos = blockEntity.method_11016();
        float f = (float) Math.pow(2, -blockEntity.pitch / 12.0);
        boolean particle = world.method_8510() % 8 == 0;
        class_310 mc = class_310.method_1551();
        class_243 eyePosition = mc.method_1560().method_33571();
        float maxVolume = (float) class_3532.method_15350((64 - eyePosition.method_1022(class_243.method_24953(pos))) / 64, 0, 1);

        WhistleSize size = blockEntity.getOctave();
        if (soundInstance == null || soundInstance.method_4793() || soundInstance.getOctave() != size) {
            mc.method_1483().method_4873(soundInstance = new WhistleSoundInstance(size, pos));
            AllSoundEvents.WHISTLE_CHIFF.playAt(world, pos, maxVolume * .175f, size == WhistleBlock.WhistleSize.SMALL ? f + .75f : f, false);
            particle = true;
        }

        soundInstance.keepAlive();
        soundInstance.setPitch(f);

        if (!particle)
            return;

        class_2350 facing = blockEntity.method_11010().method_28500(WhistleBlock.FACING).orElse(class_2350.field_11035);
        float angle = 180 + AngleHelper.horizontalAngle(facing);
        class_243 sizeOffset = VecHelper.rotate(new class_243(0, -0.4f, 1 / 16f * size.ordinal()), angle, class_2351.field_11052);
        class_243 offset = VecHelper.rotate(new class_243(0, 1, 0.75f), angle, class_2351.field_11052);
        class_243 v = offset.method_1021(.45f).method_1019(sizeOffset).method_1019(class_243.method_24953(pos));
        class_243 m = offset.method_1020(class_243.method_24954(facing.method_62675()).method_1021(.75f));
        world.method_8406(AllParticleTypes.STEAM_JET, v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
    }
}
