package com.zurrtum.create.client.foundation.gui.render;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock.HeatLevel;
import net.minecraft.class_10889;
import net.minecraft.class_11239;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.client.render.*;
import java.util.List;

public class BasinBlazeBurnerRenderer extends class_11239<BasinBlazeBurnerRenderState> {
    public BasinBlazeBurnerRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    protected void render(BasinBlazeBurnerRenderState state, class_4587 matrices) {
        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22905(1, 1, -1);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        matrices.method_22905(1, -1, 1);

        class_2680 blockState;
        List<class_10889> parts;
        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = field_59933.method_73477(class_4722.method_24074());
        float offset = -(class_3532.method_15374(AnimationTickHolder.getRenderTime() / 16f) + 0.5f) / 16f;

        blockState = AllBlocks.BLAZE_BURNER.method_9564();
        world.blockState(blockState);
        parts = blockRenderManager.method_3349(blockState).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);

        matrices.method_22903();
        blockState = class_2246.field_10124.method_9564();
        world.blockState(blockState);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        boolean seething = state.heat() == HeatLevel.SEETHING;
        parts = List.of((seething ? AllPartialModels.BLAZE_SUPER : AllPartialModels.BLAZE_ACTIVE).get());
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_46416(0, offset, 0);
        parts = List.of((seething ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2).get());
        blockRenderManager.method_3355(blockState, class_2338.field_10980, world, matrices, buffer, false, parts);
        matrices.method_22909();


        SpriteShiftEntry spriteShift = seething ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;

        float spriteWidth = spriteShift.getTarget().method_4577() - spriteShift.getTarget().method_4594();

        float spriteHeight = spriteShift.getTarget().method_4575() - spriteShift.getTarget().method_4593();

        float time = AnimationTickHolder.getRenderTime(mc.field_1687);
        float speed = 1 / 32f + 1 / 64f * state.heat().ordinal();

        double vScroll = speed * time;
        vScroll = vScroll - Math.floor(vScroll);
        vScroll = vScroll * spriteHeight / 2;

        double uScroll = speed * time / 2;
        uScroll = uScroll - Math.floor(uScroll);
        uScroll = uScroll * spriteWidth / 2;

        CachedBuffers.partial(AllPartialModels.BLAZE_BURNER_FLAME, class_2246.field_10124.method_9564())
            .shiftUVScrolling(spriteShift, (float) uScroll, (float) vScroll).light(class_765.field_32767)
            .renderInto(matrices.method_23760(), field_59933.method_73477(class_1921.method_23579()));
    }

    @Override
    protected String method_70906() {
        return "Blaze Burner";
    }

    @Override
    public Class<BasinBlazeBurnerRenderState> method_70903() {
        return BasinBlazeBurnerRenderState.class;
    }
}
