package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.minecraft.class_10366;
import net.minecraft.class_10799;
import net.minecraft.class_10889;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_2338;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_776;
import net.minecraft.class_7833;

public class ManualBlockRenderer extends class_11239<ManualBlockRenderState> {
    public static int MAX = 6;
    private int allocate = MAX;
    private static final Deque<GpuTexture> TEXTURES = new ArrayDeque<>(MAX);
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public ManualBlockRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    @Override
    public void render(ManualBlockRenderState block, class_11246 state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.forEach(GpuTexture::close);
            TEXTURES.clear();
            allocate = MAX;
        }
        int size = 27 * windowScaleFactor;
        GpuTexture texture;
        if (allocate > 0) {
            allocate--;
            texture = GpuTexture.create(size);
        } else {
            texture = TEXTURES.poll();
            assert texture != null;
        }
        RenderSystem.setProjectionMatrix(field_60042.method_71092(size, size), class_10366.field_54954);
        texture.prepare();
        matrices.method_22903();
        matrices.method_46416(size / 2.0F, size, 0.0F);
        float scale = 20 * windowScaleFactor;
        matrices.method_22905(scale, scale, scale);

        class_310 mc = class_310.method_1551();
        mc.field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-15.5f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(22.5f));
        matrices.method_46416(-0.5f, -0.2f, -0.5f);
        matrices.method_22905(1, -1, 1);

        class_776 blockRenderManager = mc.method_1541();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        class_4588 buffer = field_59933.method_73477(class_4722.method_24074());
        world.blockState(block.state());
        List<class_10889> parts = blockRenderManager.method_3349(block.state()).method_68512(mc.field_1687.field_9229);
        blockRenderManager.method_3355(block.state(), class_2338.field_10980, world, matrices, buffer, false, parts);

        field_59933.method_22993();
        matrices.method_22909();
        texture.clear();
        state.method_71996(new class_11241(
            class_10799.field_59968,
            class_11231.method_70900(texture.textureView()),
            block.method_72127(),
            block.comp_4122(),
            block.comp_4123(),
            block.comp_4124(),
            block.comp_4125(),
            0.0F,
            1.0F,
            1.0F,
            0.0F,
            -1,
            null,
            null
        ));
        TEXTURES.add(texture);
    }

    @Override
    protected void render(ManualBlockRenderState state, class_4587 matrices) {
    }

    @Override
    protected String method_70906() {
        return "Manual Block";
    }

    @Override
    public Class<ManualBlockRenderState> method_70903() {
        return ManualBlockRenderState.class;
    }
}
