package com.zurrtum.create.client.foundation.item;

import com.zurrtum.create.api.registry.SimpleRegistry;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2561;

@FunctionalInterface
public interface TooltipModifier {
    SimpleRegistry<class_1792, TooltipModifier> REGISTRY = SimpleRegistry.create();

    TooltipModifier EMPTY = new TooltipModifier() {
        @Override
        public void modify(List<class_2561> tooltip, class_1657 player) {
        }

        @Override
        public TooltipModifier andThen(TooltipModifier after) {
            return after;
        }
    };

    void modify(List<class_2561> tooltip, class_1657 player);

    default TooltipModifier andThen(TooltipModifier after) {
        if (after == EMPTY) {
            return this;
        }
        return (tooltip, player) -> {
            modify(tooltip, player);
            after.modify(tooltip, player);
        };
    }

    static TooltipModifier mapNull(@Nullable TooltipModifier modifier) {
        if (modifier == null) {
            return EMPTY;
        }
        return modifier;
    }
}
