package com.zurrtum.create.client.foundation.render;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.flywheel.lib.visualization.VisualizationHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class BlockEntityRenderHelper {
    /**
     * Renders the given list of BlockEntities, skipping those not marked in shouldRenderBEs,
     * and marking those that error in erroredBEsOut.
     *
     * @param blockEntities   The list of BlockEntities to render.
     * @param shouldRenderBEs A BitSet marking which BlockEntities in the list should be rendered. This will not be modified.
     * @param erroredBEsOut   A BitSet to mark BlockEntities that error during rendering. This will be modified.
     */
    @Nullable
    public static BlockEntityListRenderState getBlockEntitiesRenderState(
        boolean supportsVisualization,
        List<class_2586> blockEntities,
        BitSet shouldRenderBEs,
        BitSet erroredBEsOut,
        @Nullable VirtualRenderWorld renderLevel,
        class_1937 realLevel,
        class_4587 ms,
        @Nullable Matrix4f lightTransform,
        class_243 camera,
        float pt
    ) {
        int size = blockEntities.size();
        if (size == 0) {
            return null;
        }
        class_310 mc = class_310.method_1551();
        class_824 dispatcher = mc.method_31975();
        List<class_11954> states = new ArrayList<>();
        for (int i = shouldRenderBEs.nextSetBit(0); i >= 0 && i < size; i = shouldRenderBEs.nextSetBit(i + 1)) {
            class_2586 blockEntity = blockEntities.get(i);
            if (supportsVisualization && VisualizationHelper.skipVanillaRender(blockEntity)) {
                continue;
            }

            class_827<class_2586, class_11954> renderer = dispatcher.method_3550(blockEntity);
            if (renderer == null) {
                // Don't bother looping over it again if we can't do anything with it.
                erroredBEsOut.set(i);
                continue;
            }

            try {
                class_11954 renderState = renderer.method_74335();
                int realLevelLight = class_761.method_23794(realLevel, getLightPos(lightTransform, blockEntity.method_11016()));
                if (renderLevel != null) {
                    renderLevel.setExternalLight(realLevelLight);
                }
                renderer.method_74331(blockEntity, renderState, pt, camera, null);
                if (renderLevel == null) {
                    renderState.field_62676 = realLevelLight;
                }
                states.add(renderState);
            } catch (Exception e) {
                // Prevent this BE from causing more issues in the future.
                erroredBEsOut.set(i);

                String message = "BlockEntity " + RegisteredObjectsHelper.getKeyOrThrow(blockEntity.method_11017()) + " could not be rendered virtually.";
                if (AllConfigs.client().explainRenderErrors.get())
                    Create.LOGGER.error(message, e);
                else
                    Create.LOGGER.error(message);
            }
        }

        if (renderLevel != null) {
            renderLevel.resetExternalLight();
        }
        if (states.isEmpty()) {
            return null;
        }
        return new BlockEntityListRenderState(dispatcher, ms, camera, class_2338.method_49638(camera), states);
    }

    private static class_2338 getLightPos(@Nullable Matrix4f lightTransform, class_2338 contraptionPos) {
        if (lightTransform != null) {
            Vector4f lightVec = new Vector4f(contraptionPos.method_10263() + .5f, contraptionPos.method_10264() + .5f, contraptionPos.method_10260() + .5f, 1);
            lightVec.mul(lightTransform);
            return class_2338.method_49637(lightVec.x(), lightVec.y(), lightVec.z());
        } else {
            return contraptionPos;
        }
    }

    public record BlockEntityListRenderState(
        class_824 dispatcher, class_4587 matrices, class_243 camera, class_2338 cameraPos, List<class_11954> states
    ) {
        public void render(class_11659 queue, class_12075 cameraRenderState) {
            class_243 prevPos = cameraRenderState.field_63078;
            class_2338 prevBlockPos = cameraRenderState.field_63077;
            class_243 prevEntityPos = cameraRenderState.field_63080;
            cameraRenderState.field_63078 = camera;
            cameraRenderState.field_63077 = cameraPos;
            cameraRenderState.field_63080 = new class_243(
                prevEntityPos.field_1352 - prevPos.field_1352 + camera.field_1352,
                prevEntityPos.field_1351 - prevPos.field_1351 + camera.field_1351,
                prevEntityPos.field_1350 - prevPos.field_1350 + camera.field_1350
            );
            for (class_11954 state : states) {
                class_827<class_2586, class_11954> renderer = dispatcher.method_74349(state);
                if (renderer == null) {
                    continue;
                }
                class_2338 pos = state.field_62673;
                matrices.method_22903();
                matrices.method_46416(pos.method_10263(), pos.method_10264(), pos.method_10260());
                renderer.method_3569(state, matrices, queue, cameraRenderState);
                matrices.method_22909();
            }
            cameraRenderState.field_63078 = prevPos;
            cameraRenderState.field_63077 = prevBlockPos;
            cameraRenderState.field_63080 = prevEntityPos;
        }
    }
}
