package com.zurrtum.create.client.foundation.sound;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.foundation.sound.SoundScapes.AmbienceGroup;
import com.zurrtum.create.client.foundation.sound.SoundScapes.PitchGroup;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;

public class SoundScape {
    private final float pitch;
    private final AmbienceGroup group;
    private final PitchGroup pitchGroup;
    List<ContinuousSound> continuous;
    List<RepeatingSound> repeating;
    private class_243 meanPos;

    public SoundScape(float pitch, AmbienceGroup group) {
        this.pitchGroup = SoundScapes.getGroupFromPitch(pitch);
        this.pitch = pitch;
        this.group = group;
        continuous = new ArrayList<>();
        repeating = new ArrayList<>();
    }

    public SoundScape continuous(class_3414 sound, float relativeVolume, float relativePitch) {
        return add(new ContinuousSound(sound, this, pitch * relativePitch, relativeVolume));
    }

    public SoundScape repeating(class_3414 sound, float relativeVolume, float relativePitch, int delay) {
        return add(new RepeatingSound(sound, this, pitch * relativePitch, relativeVolume, delay));
    }

    public SoundScape add(ContinuousSound continuousSound) {
        continuous.add(continuousSound);
        return this;
    }

    public SoundScape add(RepeatingSound repeatingSound) {
        repeating.add(repeatingSound);
        return this;
    }

    public void play() {
        continuous.forEach(class_310.method_1551().method_1483()::method_4873);
    }

    public void tick() {
        if (AnimationTickHolder.getTicks() % SoundScapes.UPDATE_INTERVAL == 0)
            meanPos = null;
        repeating.forEach(RepeatingSound::tick);
    }

    public void remove() {
        continuous.forEach(ContinuousSound::remove);
    }

    public class_243 getMeanPos() {
        return meanPos == null ? meanPos = determineMeanPos() : meanPos;
    }

    private class_243 determineMeanPos() {
        meanPos = class_243.field_1353;
        int amount = 0;
        for (class_2338 blockPos : SoundScapes.getAllLocations(group, pitchGroup)) {
            meanPos = meanPos.method_1019(VecHelper.getCenterOf(blockPos));
            amount++;
        }
        if (amount == 0)
            return meanPos;
        return meanPos.method_1021(1f / amount);
    }

    public float getVolume() {
        class_1297 renderViewEntity = class_310.method_1551().method_1560();
        float distanceMultiplier = 0;
        if (renderViewEntity != null) {
            double distanceTo = renderViewEntity.method_73189().method_1022(getMeanPos());
            distanceMultiplier = (float) class_3532.method_16436(distanceTo / SoundScapes.MAX_AMBIENT_SOURCE_DISTANCE, 2, 0);
        }
        int soundCount = SoundScapes.getSoundCount(group, pitchGroup);
        float max = AllConfigs.client().ambientVolumeCap.getF();
        float argMax = (float) SoundScapes.SOUND_VOLUME_ARG_MAX;
        return class_3532.method_15363(soundCount / (argMax * 10f), 0.025f, max) * distanceMultiplier;
    }

}