package com.zurrtum.create.client.infrastructure.fluid;

import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.content.equipment.armor.DivingHelmetItem;
import net.minecraft.class_11403;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_6908;
import net.minecraft.class_7285;
import net.minecraft.class_746;
import net.minecraft.class_9779;

public class FluidFogModifier extends class_11403 {
    @Override
    public void method_42591(
        class_7285 data,
        class_1297 cameraEntity,
        class_2338 cameraPos,
        class_638 world,
        float viewDistance,
        class_9779 tickCounter
    ) {
        FluidConfig config = AllFluidConfigs.ALL.get(world.method_8316(cameraPos).method_15772());
        if (config != null) {
            data.field_60582 = -8.0F;
            data.field_60584 = config.fogDistance().get();
            if (cameraEntity instanceof class_746 clientPlayerEntity) {
                data.field_60584 = data.field_60584 * Math.max(0.25F, clientPlayerEntity.method_3140());
                if (world.method_23753(cameraPos).method_40220(class_6908.field_37378)) {
                    data.field_60584 *= 0.85F;
                }
            }

            data.field_60099 = data.field_60584;
            data.field_60100 = data.field_60584;
        } else {
            super.method_42591(data, cameraEntity, cameraPos, world, viewDistance, tickCounter);
        }
        class_1799 divingHelmet = DivingHelmetItem.getWornItem(cameraEntity);
        if (!divingHelmet.method_7960()) {
            data.field_60584 *= 6.25F;
        }
    }

    @Override
    public int method_71654(class_638 world, class_4184 camera, int viewDistance, float skyDarkness) {
        FluidConfig config = AllFluidConfigs.ALL.get(world.method_8316(camera.method_19328()).method_15772());
        if (config != null) {
            if (config.fogColor() != -1) {
                return config.fogColor();
            }
        }
        return super.method_71654(world, camera, viewDistance, skyDarkness);
    }
}
