package com.zurrtum.create.client.infrastructure.particle;

import net.minecraft.class_2400;
import net.minecraft.class_3532;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.joml.Quaternionf;

public class WiFiParticle extends CustomRotationParticle {
    private final boolean downward;

    public WiFiParticle(
        class_2400 type,
        class_4002 spriteSet,
        class_638 worldIn,
        double x,
        double y,
        double z,
        double vx,
        double vy,
        double vz,
        class_5819 random
    ) {
        super(worldIn, x, y + (vy < 0 ? -1 : 1), z, spriteSet, 0);
        this.field_17867 = 0.5f;
        this.method_3080(this.field_17867, this.field_17867);
        this.loopLength = 16;
        this.field_3847 = 16;
        this.method_74306(spriteSet);
        this.field_21507 = true; // disable movement
        this.downward = vy < 0;
    }

    @Override
    public void method_3070() {
        method_74306(field_17866);
        if (field_3866++ >= field_3847)
            method_3085();
    }

    @Override
    public Quaternionf getCustomRotation(class_4184 camera, float partialTicks) {
        Quaternionf rotation = camera.method_23767();
        Quaternionf quaternionf = new Quaternionf(0, rotation.y, 0, rotation.w);
        if (downward) {
            quaternionf.rotateZ(class_3532.field_29844);
        }
        return quaternionf;
    }
}
