package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_5244;

public class DisplayScenes {

    public static void link(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("display_link", "Setting up Display Links");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();

        class_2338 depotPos = util.grid().at(3, 1, 1);
        Selection depot = util.select().position(3, 1, 1);
        class_2338 linkPos = util.grid().at(2, 1, 1);
        Selection link = util.select().position(linkPos);
        class_2338 board = util.grid().at(3, 2, 3);
        Selection fullBoard = util.select().fromTo(3, 2, 3, 1, 1, 3);
        Selection largeCog = util.select().position(3, 0, 5);
        Selection smallCog = util.select().fromTo(4, 1, 5, 4, 1, 3);

        Selection cuckoo = util.select().position(3, 2, 1);
        Selection stresso = util.select().position(3, 3, 1);
        Selection content = util.select().fromTo(4, 4, 1, 3, 4, 1);
        Selection dirt = util.select().position(3, 5, 1);

        Selection lectern = util.select().position(2, 2, 4);
        Selection sign = util.select().position(2, 1, 4);
        Selection nixies = util.select().fromTo(3, 3, 4, 1, 3, 4);

        scene.idle(15);

        scene.world().showSection(util.select().position(2, 1, 2), class_2350.field_11033);

        scene.idle(10);

        scene.overlay().showText(70).attachKeyFrame().text("Display Links can be used to visualise dynamic information")
            .pointAt(util.vector().blockSurface(util.grid().at(2, 1, 2), class_2350.field_11039)).placeNearTarget();
        scene.idle(60);

        scene.world().hideSection(util.select().position(2, 1, 2), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.world().showSection(smallCog, class_2350.field_11039);
        scene.idle(5);
        scene.world().showSection(fullBoard, class_2350.field_11043);
        scene.idle(25);

        class_243 target = util.vector().of(3.5, 2.75, 3.25);
        scene.overlay().showControls(target, Pointing.RIGHT, 60).withItem(AllItems.DISPLAY_LINK.method_7854()).rightClick();
        scene.idle(6);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, link, new class_238(board).method_1012(-2, -1, 0).method_35580(0, 0, 3 / 16f), 60);
        scene.idle(35);
        scene.overlay().showText(70).text("First, right-click the target display...").pointAt(target.method_1031(-1, 0, 0)).colored(PonderPalette.OUTPUT)
            .attachKeyFrame().placeNearTarget();
        scene.idle(60);

        scene.world().showSection(depot, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(link, class_2350.field_11034);
        scene.idle(20);
        scene.overlay().showOutlineWithText(depot, 70).text("...then attach it to the block to read from").pointAt(util.vector().centerOf(linkPos))
            .colored(PonderPalette.INPUT).placeNearTarget();
        scene.idle(60);

        class_1799 item = AllItems.PROPELLER.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.idle(20);

        scene.overlay().showControls(util.vector().topOf(linkPos), Pointing.DOWN, 60).rightClick();
        scene.idle(20);
        scene.overlay().showText(80).text("Open the Interface to select and configure what is sent").pointAt(util.vector().centerOf(linkPos))
            .attachKeyFrame().placeNearTarget();
        scene.idle(80);
        scene.effects().indicateSuccess(linkPos);
        scene.world().setDisplayBoardText(board, 1, item.method_7964());
        scene.world().flashDisplayLink(linkPos);
        scene.idle(50);

        scene.world().removeItemsFromBelt(depotPos);
        item = AllItems.BLAZE_CAKE.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.world().setDisplayBoardText(board, 1, item.method_7964());
        scene.world().flashDisplayLink(linkPos);
        scene.idle(20);

        scene.overlay().showText(80).text("The display will now receive information from the link").pointAt(target.method_1031(-2.45f, -.5f, 0))
            .attachKeyFrame().placeNearTarget();

        scene.idle(30);
        scene.world().removeItemsFromBelt(depotPos);
        item = AllItems.DISPLAY_BOARD.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.world().setDisplayBoardText(board, 1, item.method_7964());
        scene.world().flashDisplayLink(linkPos);
        scene.idle(50);

        scene.world().hideSection(depot, class_2350.field_11035);
        scene.idle(5);
        scene.world().setDisplayBoardText(board, 1, class_5244.field_39003);
        scene.world().flashDisplayLink(linkPos);
        scene.idle(5);
        ElementLink<WorldSectionElement> dirtElement = scene.world().showIndependentSection(dirt, class_2350.field_11035);
        scene.world().moveSection(dirtElement, util.vector().of(0, -4, 0), 0);

        scene.idle(25);
        scene.overlay().showOutlineWithText(depot, 50).text("Not every block can act as a source").pointAt(util.vector().topOf(depotPos))
            .attachKeyFrame().colored(PonderPalette.RED).placeNearTarget();
        scene.idle(60);
        scene.world().hideIndependentSection(dirtElement, class_2350.field_11035);
        scene.idle(10);

        ElementLink<WorldSectionElement> stressElement = scene.world().showIndependentSection(stresso, class_2350.field_11035);
        scene.world().moveSection(stressElement, util.vector().of(0, -2, 0), 0);
        scene.idle(10);
        scene.world().setDisplayBoardText(board, 1, class_2561.method_43470(1024 + " ").method_10852(CreateLang.translateDirect("generic.unit.stress")));
        scene.world().flashDisplayLink(linkPos);
        scene.idle(40);
        scene.world().hideIndependentSection(stressElement, class_2350.field_11035);
        scene.idle(10);

        ElementLink<WorldSectionElement> chestElement = scene.world().showIndependentSection(content, class_2350.field_11035);
        scene.world().moveSection(chestElement, util.vector().of(0, -3, 0), 0);
        scene.idle(10);
        scene.world().setDisplayBoardText(board, 1, class_2561.method_43470(418 + " ").method_10852(new class_1799(class_1802.field_28866).method_7964()));
        scene.world().setDisplayBoardText(board, 2, class_2561.method_43470(14 + " ").method_10852(AllItems.COGWHEEL.method_7854().method_7964()));
        scene.world().flashDisplayLink(linkPos);
        scene.idle(40);
        scene.world().hideIndependentSection(chestElement, class_2350.field_11035);
        scene.idle(10);

        scene.overlay().showText(90).text("Each compatible block provides unique information").pointAt(util.vector().topOf(depotPos)).attachKeyFrame()
            .colored(PonderPalette.GREEN).placeNearTarget();

        ElementLink<WorldSectionElement> cuckooElement = scene.world().showIndependentSection(cuckoo, class_2350.field_11035);
        scene.world().moveSection(cuckooElement, util.vector().of(0, -1, 0), 0);
        scene.idle(10);
        scene.world().setDisplayBoardText(board, 1, class_2561.method_43470("6:00 ").method_10852(CreateLang.translateDirect("generic.daytime.pm")));
        scene.world().setDisplayBoardText(board, 2, class_5244.field_39003);
        scene.world().flashDisplayLink(linkPos);
        scene.idle(90);

        scene.world().hideSection(fullBoard, class_2350.field_11035);
        scene.world().hideSection(largeCog, class_2350.field_11033);
        scene.world().hideSection(smallCog, class_2350.field_11034);
        scene.idle(10);

        ElementLink<WorldSectionElement> signElement = scene.world().showIndependentSection(sign, class_2350.field_11035);
        scene.world().moveSection(signElement, util.vector().of(0, 0, -1), 0);
        scene.idle(10);
        scene.world().flashDisplayLink(linkPos);
        scene.idle(5);
        scene.world().hideIndependentSection(signElement, class_2350.field_11035);
        scene.idle(10);

        ElementLink<WorldSectionElement> lecternElement = scene.world().showIndependentSection(lectern, class_2350.field_11035);
        scene.world().moveSection(lecternElement, util.vector().of(0, -1, -1), 0);
        scene.idle(10);
        scene.world().flashDisplayLink(linkPos);
        scene.idle(5);
        scene.world().hideIndependentSection(lecternElement, class_2350.field_11035);
        scene.idle(10);

        scene.overlay().showText(90).text("The Display Link can work with several different displays")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 1, 3), class_2350.field_11039)).attachKeyFrame().colored(PonderPalette.GREEN)
            .placeNearTarget();

        ElementLink<WorldSectionElement> nixieElement = scene.world().showIndependentSection(nixies, class_2350.field_11035);
        scene.world().moveSection(nixieElement, util.vector().of(0, -2, -1), 0);
        scene.idle(10);
        scene.world().flashDisplayLink(linkPos);
        scene.idle(60);
    }

    public static void board(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("display_board", "Using Display Boards");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();

        Selection largeCog = util.select().position(5, 0, 1);
        Selection cogs = util.select().fromTo(4, 1, 1, 4, 1, 3);
        class_2338 depotPos = util.grid().at(3, 1, 1);
        Selection depot = util.select().position(3, 1, 1);
        class_2338 linkPos = util.grid().at(2, 1, 1);
        Selection link = util.select().position(linkPos);
        class_2338 board = util.grid().at(3, 2, 3);
        Selection fullBoard = util.select().fromTo(3, 2, 3, 1, 1, 3);

        scene.world().setKineticSpeed(fullBoard, 0);
        scene.idle(15);

        for (int y = 1; y <= 2; y++) {
            for (int x = 3; x >= 1; x--) {
                scene.world().showSection(util.select().position(x, y, 3), class_2350.field_11033);
                scene.idle(2);
            }
            scene.idle(2);
        }

        scene.idle(10);

        scene.overlay().showText(70).attachKeyFrame().text("Display Boards are a scalable alternative to the sign")
            .pointAt(util.vector().blockSurface(util.grid().at(1, 2, 3), class_2350.field_11039)).placeNearTarget();
        scene.idle(80);

        scene.rotateCameraY(60);
        scene.idle(20);
        scene.world().showSection(cogs, class_2350.field_11033);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.idle(10);
        scene.world().setKineticSpeed(fullBoard, 32);
        scene.world().multiplyKineticSpeed(util.select().position(3, 1, 3), -1);
        scene.world().multiplyKineticSpeed(util.select().position(2, 2, 3), -1);
        scene.world().multiplyKineticSpeed(util.select().position(1, 1, 3), -1);

        scene.overlay().showText(50).text("They require Rotational Force to operate")
            .pointAt(util.vector().blockSurface(util.grid().at(3, 1, 3), class_2350.field_11034)).attachKeyFrame().placeNearTarget();
        scene.idle(40);
        scene.rotateCameraY(-60);
        scene.idle(20);

        class_243 target = util.vector().of(3.95, 2.75, 3.25);
        class_1799 clipboard = AllItems.CLIPBOARD.method_7854();
        clipboard.method_57379(AllDataComponents.CLIPBOARD_CONTENT, ClipboardContent.EMPTY.setType(ClipboardType.WRITTEN));
        scene.overlay().showControls(target, Pointing.RIGHT, 40).withItem(clipboard).rightClick();
        scene.idle(6);
        scene.world().setDisplayBoardText(board, 0, class_2561.method_43470("Create"));
        scene.idle(25);

        scene.overlay().showText(50).text("Static text can be applied using written Clipboards").pointAt(target.method_1031(-2, 0, 0)).attachKeyFrame()
            .placeNearTarget();
        scene.idle(80);

        scene.world().showSection(depot, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(link, class_2350.field_11034);
        scene.idle(15);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, depot, new class_238(linkPos).method_1002(-.5f, 0, 0), 60);
        scene.idle(5);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, link, new class_238(board).method_1012(-2, -1, 0).method_35580(0, 0, 3 / 16f), 60);
        scene.idle(20);

        scene.overlay().showText(70).text("And dynamic text through the use of Display Links").pointAt(target.method_1031(-2, 0, 0)).attachKeyFrame()
            .colored(PonderPalette.OUTPUT).placeNearTarget();
        scene.idle(50);

        class_1799 item = AllItems.PROPELLER.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.world().setDisplayBoardText(board, 1, item.method_7964());
        scene.world().flashDisplayLink(linkPos);
        scene.idle(50);

        scene.world().removeItemsFromBelt(depotPos);
        item = AllItems.BLAZE_CAKE.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.world().setDisplayBoardText(board, 1, item.method_7964());
        scene.world().flashDisplayLink(linkPos);
        scene.idle(50);

        scene.world().removeItemsFromBelt(depotPos);
        item = AllItems.DISPLAY_BOARD.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.world().setDisplayBoardText(board, 1, item.method_7964());
        scene.world().flashDisplayLink(linkPos);
        scene.idle(50);

        scene.overlay().showControls(target, Pointing.RIGHT, 40).withItem(new class_1799(class_1802.field_8330)).rightClick();
        scene.idle(6);
        scene.world().dyeDisplayBoard(board, 0, class_1767.field_7954);
        scene.idle(25);

        scene.overlay().showText(70).text("Dyes can be applied to individual lines of the board").pointAt(target.method_1031(-2, 0, 0)).attachKeyFrame()
            .placeNearTarget();
        scene.idle(25);

        scene.overlay().showControls(target.method_1031(0, -.5f, 0), Pointing.RIGHT, 40).withItem(new class_1799(class_1802.field_8131)).rightClick();
        scene.idle(6);
        scene.world().dyeDisplayBoard(board, 1, class_1767.field_7961);
        scene.idle(55);

        scene.overlay().showControls(target, Pointing.RIGHT, 40).rightClick();
        scene.idle(6);
        scene.world().setDisplayBoardText(board, 0, class_5244.field_39003);
        scene.idle(25);

        scene.overlay().showText(70).text("Lines can be reset by clicking them with an empty hand").pointAt(target.method_1031(-2, 0, 0)).attachKeyFrame()
            .placeNearTarget();
        scene.idle(40);

    }

    public static void redstone(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("display_link_redstone", "Redstone Control");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();

        class_2338 depotPos = util.grid().at(3, 1, 1);
        Selection depot = util.select().position(3, 1, 1);
        class_2338 linkPos = util.grid().at(2, 1, 1);
        Selection link = util.select().position(linkPos);
        class_2338 board = util.grid().at(3, 2, 3);
        Selection fullBoard = util.select().fromTo(3, 2, 3, 1, 1, 3);
        Selection largeCog = util.select().position(3, 0, 5);
        Selection smallCog = util.select().fromTo(4, 1, 5, 4, 1, 3);
        Selection redstone = util.select().fromTo(1, 1, 1, 0, 1, 1);
        class_2338 leverPos = util.grid().at(0, 1, 1);

        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.world().showSection(smallCog, class_2350.field_11039);
        scene.idle(5);
        scene.world().showSection(fullBoard, class_2350.field_11043);
        scene.idle(25);

        class_243 target = util.vector().of(3.5, 2.75, 3.25);
        scene.world().showSection(depot, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(link, class_2350.field_11034);
        scene.idle(10);
        scene.world().flashDisplayLink(linkPos);
        scene.world().setDisplayBoardText(board, 1, new class_1799(class_1802.field_27020).method_7964());
        scene.idle(10);
        scene.world().showSection(redstone, class_2350.field_11034);
        scene.idle(20);
        scene.world().toggleRedstonePower(redstone);
        scene.world().toggleRedstonePower(link);
        scene.effects().indicateRedstone(leverPos);

        scene.idle(20);
        scene.overlay().showText(80).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector().topOf(linkPos)).placeNearTarget()
            .text("When powered by Redstone, Display Links stop sending updates");

        scene.idle(50);
        scene.world().removeItemsFromBelt(depotPos);
        class_1799 item = new class_1799(class_1802.field_27064);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.idle(20);

        scene.idle(30);
        scene.world().removeItemsFromBelt(depotPos);
        item = new class_1799(class_1802.field_8494);
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11035, item);
        scene.idle(50);

        scene.world().toggleRedstonePower(redstone);
        scene.world().toggleRedstonePower(link);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(1);
        scene.world().flashDisplayLink(linkPos);
        scene.world().setDisplayBoardText(board, 1, item.method_7964());

        scene.idle(15);
        scene.overlay().showText(100).colored(PonderPalette.GREEN).attachKeyFrame().pointAt(target.method_1031(-2.45, -0.5, 0)).placeNearTarget()
            .text("Once unpowered, the Timer is reset and new info is sent immediately");
        scene.idle(100);

        scene.world().hideSection(depot, class_2350.field_11035);
        scene.world().setBlock(util.grid().at(4, 1, 0), class_2246.field_10002.method_9564(), false);
        scene.idle(10);
        ElementLink<WorldSectionElement> redstoneBlock = scene.world().showIndependentSection(util.select().position(4, 1, 0), class_2350.field_11035);
        scene.world().moveSection(redstoneBlock, util.vector().of(-1, 0, 1), 0);
        scene.idle(10);
        scene.world().flashDisplayLink(linkPos);
        scene.world().setDisplayBoardText(board, 1, class_5244.field_39003);
        scene.idle(25);

        scene.overlay().showOutlineWithText(depot, 80).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector().topOf(linkPos))
            .placeNearTarget().text("Signals emitted from the source do not affect the Link");
        scene.idle(70);

    }

}