package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlock;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_6903;
import net.minecraft.class_8824;

public class ElevatorScenes {

    public static void elevator(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("elevator_pulley", "Using the Elevator Pulley");
        scene.configureBasePlate(1, 0, 5);
        scene.scaleSceneView(.85f);
        scene.removeShadow();
        scene.setSceneOffsetY(-1.5f);

        Selection topFloor = util.select().fromTo(5, 12, 0, 1, 12, 4);
        Selection midFloor = util.select().fromTo(5, 6, 0, 1, 6, 4);
        Selection botFloor = util.select().fromTo(5, 0, 0, 1, 0, 4);
        Selection topCutout = util.select().fromTo(4, 12, 3, 2, 12, 1);
        Selection midCutout = util.select().fromTo(4, 6, 3, 2, 6, 1);
        Selection botCutout = util.select().fromTo(4, 0, 3, 2, 0, 1);
        class_2338 topContact = util.grid().at(1, 13, 2);
        class_2338 midContact = util.grid().at(1, 7, 2);
        class_2338 botContact = util.grid().at(1, 1, 2);
        Selection outputRedstone = util.select().fromTo(0, 0, 2, 0, 1, 2);
        Selection topInput = util.select().fromTo(1, 13, 0, 1, 13, 1);
        Selection midInput = util.select().fromTo(1, 7, 0, 1, 7, 1);
        Selection botInput = util.select().fromTo(1, 1, 0, 1, 1, 1);
        Selection pole = util.select().fromTo(6, 0, 3, 6, 17, 3).add(util.select().position(5, 17, 3));
        Selection cog = util.select().fromTo(5, 18, 2, 4, 18, 2);
        class_2338 nixiePos = util.grid().at(4, 13, 0);
        class_2338 linkPos = util.grid().at(1, 14, 2);
        class_2338 doorPos = util.grid().at(3, 14, 1);
        Selection controls = util.select().position(4, 14, 2);
        class_2338 pulleyPos = util.grid().at(3, 18, 2);

        ElementLink<WorldSectionElement> camLink = scene.world().showIndependentSection(topFloor, class_2350.field_11036);
        scene.world().moveSection(camLink, util.vector().of(0, -12, 0), 0);
        scene.world().setKineticSpeed(util.select().position(pulleyPos), 0);
        scene.idle(5);
        ElementLink<WorldSectionElement> pulleyLink = scene.world().showIndependentSection(util.select().position(pulleyPos), class_2350.field_11033);
        scene.world().moveSection(pulleyLink, util.vector().of(0, -16, 0), 0);
        scene.idle(15);

        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 2, 2), class_2350.field_11039))
            .text("Elevator Pulleys can move structures vertically between marked locations");
        scene.idle(60);
        scene.world().moveSection(pulleyLink, util.vector().of(0, 4, 0), 20);
        scene.world().setBlocks(topCutout, class_2246.field_10124.method_9564(), false);
        scene.idle(5);

        ElementLink<WorldSectionElement> elevatorLink = scene.world()
            .showIndependentSection(util.select().fromTo(4, 13, 3, 2, 13, 1), class_2350.field_11033);
        scene.world().moveSection(elevatorLink, util.vector().of(0, -13, 0), 0);
        scene.idle(10);
        scene.world().showSectionAndMerge(util.select().fromTo(4, 14, 1, 4, 16, 1), class_2350.field_11033, elevatorLink);
        scene.idle(2);
        scene.world().showSectionAndMerge(util.select().fromTo(2, 14, 1, 2, 16, 1), class_2350.field_11033, elevatorLink);
        scene.idle(2);
        scene.world().showSectionAndMerge(util.select().fromTo(4, 14, 3, 4, 16, 3), class_2350.field_11033, elevatorLink);
        scene.idle(2);
        scene.world().showSectionAndMerge(util.select().fromTo(2, 14, 3, 2, 16, 3), class_2350.field_11033, elevatorLink);
        scene.idle(10);
        scene.world().showSectionAndMerge(util.select().fromTo(4, 17, 1, 2, 17, 3), class_2350.field_11033, elevatorLink);

        scene.overlay().showText(40).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(2, 2, 1), class_2350.field_11036))
            .text("Start by constructing a cabin");
        scene.idle(30);

        scene.world().showSectionAndMerge(util.select().position(2, 14, 2), class_2350.field_11039, elevatorLink);
        scene.idle(2);
        scene.world().showSectionAndMerge(util.select().position(1, 13, 2), class_2350.field_11034, camLink);
        scene.idle(15);
        scene.world().toggleRedstonePower(util.select().fromTo(2, 14, 2, 1, 13, 2));
        scene.idle(15);

        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(1, 2, 1), class_2350.field_11036))
            .text("Place a pair of Redstone Contacts facing each other...");
        scene.idle(55);

        class_238 glue1 = new class_238(util.grid().at(3, 4, 2));
        class_238 glue2 = glue1.method_1009(1, 0, 1).method_1012(0, -4, 0);

        scene.overlay().showControls(util.vector().centerOf(4, 3, 1), Pointing.RIGHT, 60).withItem(AllItems.SUPER_GLUE.method_7854());
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, glue1, glue1, 5);
        scene.idle(1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, glue1, glue2, 90);
        scene.idle(10);

        scene.overlay().showOutlineWithText(util.select().position(2, 1, 2), 80).placeNearTarget().colored(PonderPalette.GREEN)
            .pointAt(util.vector().blockSurface(util.grid().at(1, 2, 1), class_2350.field_11036)).text("...and glue one of them to your moving structure");
        scene.idle(70);

        scene.world().showSectionAndMerge(controls, class_2350.field_11033, elevatorLink);
        scene.idle(15);
        scene.effects().superGlue(util.grid().at(4, 1, 2), class_2350.field_11033, true);

        scene.overlay().showText(80).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(4, 1, 2), class_2350.field_11036))
            .text("Contraption Controls can be attached to make floor selection easier");
        scene.idle(70);

        scene.world().showSectionAndMerge(cog, class_2350.field_11033, camLink);
        scene.world().showSectionAndMerge(pole, class_2350.field_11036, camLink);
        scene.idle(10);
        scene.world().setKineticSpeed(util.select().position(pulleyPos), 64);
        scene.idle(5);

        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(3, 6, 2), class_2350.field_11039))
            .text("Ensure that the pulley is supplied with Rotational Power");
        scene.idle(75);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(3, 6, 2), class_2350.field_11043), Pointing.RIGHT, 60).rightClick();
        scene.idle(7);
        scene.effects().indicateSuccess(util.grid().at(3, 6, 2));
        scene.world().toggleRedstonePower(util.select().position(1, 13, 2));
        scene.world().setBlock(
            topContact,
            AllBlocks.ELEVATOR_CONTACT.method_9564().method_11657(ElevatorContactBlock.field_10927, class_2350.field_11034).method_11657(ElevatorContactBlock.POWERING, true),
            false
        );
        scene.world().movePulley(pulleyPos, 1, 0);

        scene.overlay().showText(50).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(3, 6, 2), class_2350.field_11039))
            .text("Right-Clicking the pulley assembles the elevator");
        scene.idle(60);

        scene.overlay().showText(70).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11036))
            .text("The stationary contact now turns into an Elevator Contact");
        scene.idle(80);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11036), Pointing.DOWN, 60).rightClick();
        scene.idle(7);
        scene.overlay().showOutlineWithText(util.select().position(1, 1, 2), 60).placeNearTarget().colored(PonderPalette.BLUE)
            .pointAt(util.vector().blockSurface(util.grid().at(1, 1, 2), class_2350.field_11036))
            .text("Elevator Contacts represent a 'floor' and can be configured");
        scene.idle(75);

        scene.world().moveSection(elevatorLink, util.vector().of(0, 7, 0), 15);
        scene.world().moveSection(camLink, util.vector().of(0, 7, 0), 15);
        scene.world().moveSection(pulleyLink, util.vector().of(0, 7, 0), 15);
        scene.addLazyKeyframe();
        scene.world().setBlocks(midCutout, class_2246.field_10124.method_9564(), false);
        scene.idle(15);
        scene.world().showSectionAndMerge(midFloor, class_2350.field_11034, camLink);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(midContact), class_2350.field_11033, camLink);
        scene.idle(10);
        scene.effects().indicateSuccess(util.grid().at(1, 2, 2));
        scene.world().setBlock(midContact, AllBlocks.ELEVATOR_CONTACT.method_9564().method_11657(ElevatorContactBlock.field_10927, class_2350.field_11034), false);
        scene.idle(15);

        class_238 bb = new class_238(util.grid().at(1, 8, 2));
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, bb, bb, 5);
        scene.idle(1);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.WHITE, bb, bb.method_1012(0, -6, 0), 90);
        scene.idle(10);

        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(1, 2, 2), class_2350.field_11036))
            .text("Any redstone contact sharing this column will be converted");
        scene.idle(50);
        scene.world().showSectionAndMerge(midInput, class_2350.field_11035, camLink);
        scene.idle(15);

        scene.world().toggleRedstonePower(midInput);
        scene.effects().indicateRedstone(util.grid().at(1, 2, 0));
        scene.world().cycleBlockProperty(midContact, ElevatorContactBlock.CALLING);
        scene.world().cycleBlockProperty(topContact, ElevatorContactBlock.POWERING);
        scene.world().moveSection(elevatorLink, util.vector().of(0, -6, 0), 60);
        scene.world().movePulley(pulleyPos, 6, 60);
        scene.idle(20);
        scene.world().toggleRedstonePower(midInput);
        scene.idle(10);

        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(1, 1, 0), class_2350.field_11036))
            .text("Supply a redstone pulse to call the elevator to the contact");

        scene.idle(30);
        scene.world().cycleBlockProperty(midContact, ElevatorContactBlock.CALLING);
        scene.world().cycleBlockProperty(midContact, ElevatorContactBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().position(1, 7, 1));
        scene.idle(40);

        scene.overlay().showText(70).placeNearTarget().pointAt(util.vector().centerOf(util.grid().at(2, 3, 3)))
            .text("The movement speed depends on the rotation input on the pulley");
        scene.idle(80);
        scene.addLazyKeyframe();
        scene.idle(10);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(4, 2, 2), class_2350.field_11036), Pointing.DOWN, 60).scroll();
        scene.idle(15);
        scene.overlay().showText(90).placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(4, 2, 2), class_2350.field_11036))
            .text("Scroll and click on the controls block to choose a floor while on-board");
        scene.idle(85);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(4, 2, 2), class_2350.field_11036), Pointing.DOWN, 10).rightClick();
        scene.idle(7);
        scene.world().cycleBlockProperty(midContact, ElevatorContactBlock.POWERING);
        scene.world().cycleBlockProperty(topContact, ElevatorContactBlock.CALLING);
        scene.world().toggleRedstonePower(util.select().position(1, 7, 1));
        scene.world().moveSection(camLink, util.vector().of(0, -7, 0), 60);
        scene.world().moveSection(pulleyLink, util.vector().of(0, -7, 0), 60);
        scene.world().moveSection(elevatorLink, util.vector().of(0, -1, 0), 60);
        scene.world().movePulley(pulleyPos, -6, 60);
        scene.idle(60);

        scene.world().cycleBlockProperty(topContact, ElevatorContactBlock.POWERING);
        scene.world().cycleBlockProperty(topContact, ElevatorContactBlock.CALLING);
        scene.idle(15);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(3, 6, 2), class_2350.field_11043), Pointing.RIGHT, 60).rightClick();
        scene.idle(7);
        scene.effects().indicateSuccess(util.grid().at(3, 6, 2));
        scene.world().movePulley(pulleyPos, -1, 0);

        scene.overlay().showText(80).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(3, 6, 2), class_2350.field_11039))
            .text("Right-Clicking the assembled pulley will turn the cabin back into blocks");
        scene.idle(90);

        scene.world().showSectionAndMerge(util.select().fromTo(doorPos, doorPos.method_10084()), class_2350.field_11033, elevatorLink);
        scene.idle(20);

        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(3, 6, 2), class_2350.field_11043), Pointing.RIGHT, 60).rightClick();
        scene.idle(7);
        scene.effects().indicateSuccess(util.grid().at(3, 6, 2));
        scene.world().movePulley(pulleyPos, 1, 0);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.field_10945);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.VISIBLE);
        scene.world().cycleBlockProperty(doorPos.method_10084(), SlidingDoorBlock.VISIBLE);

        scene.overlay().showText(80).placeNearTarget().attachKeyFrame().pointAt(util.vector().blockSurface(util.grid().at(3, 1, 1), class_2350.field_11043))
            .text("Sliding doors attached to the cabin will open and close automatically");
        scene.idle(90);

        scene.world().moveSection(elevatorLink, util.vector().of(0, 13, 0), 15);
        scene.world().moveSection(camLink, util.vector().of(0, 13, 0), 15);
        scene.world().moveSection(pulleyLink, util.vector().of(0, 13, 0), 15);
        scene.world().setBlocks(botCutout, class_2246.field_10124.method_9564(), false);
        scene.idle(15);
        scene.world().showSectionAndMerge(botFloor, class_2350.field_11034, camLink);
        scene.idle(5);
        scene.world().showSectionAndMerge(util.select().position(botContact), class_2350.field_11033, camLink);
        scene.idle(10);
        scene.effects().indicateSuccess(util.grid().at(1, 2, 2));
        scene.world().setBlock(botContact, AllBlocks.ELEVATOR_CONTACT.method_9564().method_11657(ElevatorContactBlock.field_10927, class_2350.field_11034), false);
        scene.idle(5);
        scene.world().showSectionAndMerge(botInput, class_2350.field_11035, camLink);
        scene.idle(15);

        scene.world().toggleRedstonePower(botInput);
        scene.effects().indicateRedstone(util.grid().at(1, 2, 0));
        scene.world().cycleBlockProperty(botContact, ElevatorContactBlock.CALLING);
        scene.world().cycleBlockProperty(topContact, ElevatorContactBlock.POWERING);
        scene.world().moveSection(elevatorLink, util.vector().of(0, -12, 0), 50);
        scene.world().movePulley(pulleyPos, 12, 50);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.field_10945);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.VISIBLE);
        scene.world().cycleBlockProperty(doorPos.method_10084(), SlidingDoorBlock.VISIBLE);
        scene.idle(20);

        scene.world().toggleRedstonePower(botInput);
        scene.world().showSectionAndMerge(outputRedstone, class_2350.field_11034, camLink);
        scene.idle(30);

        scene.world().cycleBlockProperty(botContact, ElevatorContactBlock.CALLING);
        scene.world().cycleBlockProperty(botContact, ElevatorContactBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().position(1, 1, 1));
        scene.world().toggleRedstonePower(outputRedstone);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.field_10945);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.VISIBLE);
        scene.world().cycleBlockProperty(doorPos.method_10084(), SlidingDoorBlock.VISIBLE);
        scene.idle(15);

        scene.overlay().showText(80).placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(0, 1, 2))
            .text("Elevator Contacts emit a signal while the cabin is on their floor");
        scene.idle(90);

        scene.overlay().showText(80).placeNearTarget().pointAt(util.vector().topOf(0, 1, 2))
            .text("This can be useful to trigger doors or special effects upon arrival");
        scene.idle(90);

        scene.world().setBlock(nixiePos, AllBlocks.GREEN_NIXIE_TUBE.method_9564().method_11657(NixieTubeBlock.field_11177, class_2350.field_11039), false);

        scene.world().moveSection(camLink, util.vector().of(0, -13, 0), 20);
        scene.world().moveSection(pulleyLink, util.vector().of(0, -13, 0), 20);
        scene.world().moveSection(elevatorLink, util.vector().of(0, -13, 0), 20);
        scene.idle(30);
        scene.world().showSectionAndMerge(util.select().position(nixiePos), class_2350.field_11033, camLink);
        scene.idle(15);
        scene.overlay().showControls(util.vector().blockSurface(util.grid().at(4, 1, 0), class_2350.field_11036), Pointing.DOWN, 15).rightClick()
            .withItem(AllItems.DISPLAY_LINK.method_7854());
        scene.world().toggleRedstonePower(util.select().position(1, 14, 2));
        scene.idle(15);
        scene.world().showSectionAndMerge(util.select().position(linkPos), class_2350.field_11033, camLink);
        scene.world().flashDisplayLink(linkPos);
        scene.world().modifyBlockEntityNBT(
            util.select().position(nixiePos), NixieTubeBlockEntity.class, nbt -> {
                class_6903<class_2520> ops = scene.world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                class_2561 component = class_2561.method_43470("0F");
                nbt.method_67493("CustomText", class_8824.field_46597, ops, component);
            }
        );

        scene.overlay().showText(90).placeNearTarget().attachKeyFrame().pointAt(util.vector().centerOf(1, 2, 2))
            .text("Display Links on any of the contacts can show the current floor of the elevator");
        scene.idle(90);

        scene.world().showSectionAndMerge(topInput, class_2350.field_11035, camLink);
        scene.idle(15);

        scene.world().toggleRedstonePower(topInput);
        scene.effects().indicateRedstone(util.grid().at(1, 2, 0));
        scene.world().cycleBlockProperty(topContact, ElevatorContactBlock.CALLING);
        scene.world().cycleBlockProperty(botContact, ElevatorContactBlock.POWERING);
        scene.world().moveSection(elevatorLink, util.vector().of(0, 12, 0), 70);
        scene.world().movePulley(pulleyPos, -12, 70);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.field_10945);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.VISIBLE);
        scene.world().cycleBlockProperty(doorPos.method_10084(), SlidingDoorBlock.VISIBLE);
        scene.idle(20);

        scene.world().toggleRedstonePower(topInput);
        scene.idle(10);

        scene.world().flashDisplayLink(linkPos);
        scene.world().modifyBlockEntityNBT(
            util.select().position(nixiePos), NixieTubeBlockEntity.class, nbt -> {
                class_6903<class_2520> ops = scene.world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                class_2561 component = class_2561.method_43470("1F");
                nbt.method_67493("CustomText", class_8824.field_46597, ops, component);
            }
        );

        scene.idle(40);

        scene.world().cycleBlockProperty(topContact, ElevatorContactBlock.CALLING);
        scene.world().cycleBlockProperty(topContact, ElevatorContactBlock.POWERING);
        scene.world().toggleRedstonePower(util.select().position(1, 13, 1));
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.field_10945);
        scene.world().cycleBlockProperty(doorPos, SlidingDoorBlock.VISIBLE);
        scene.world().cycleBlockProperty(doorPos.method_10084(), SlidingDoorBlock.VISIBLE);

        scene.world().flashDisplayLink(linkPos);
        scene.world().modifyBlockEntityNBT(
            util.select().position(nixiePos), NixieTubeBlockEntity.class, nbt -> {
                class_6903<class_2520> ops = scene.world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                class_2561 component = class_2561.method_43470("2F");
                nbt.method_67493("CustomText", class_8824.field_46597, ops, component);
            }
        );
    }

    public static void multiRope(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("elevator_pulley_multi_rope", "Synchronised Pulley Movement");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1);
        scene.scaleSceneView(.95f);
        scene.showBasePlate();
        scene.idle(5);

        Selection mainPulley = util.select().fromTo(5, 0, 1, 5, 4, 1).add(util.select().fromTo(4, 4, 1, 3, 4, 1));
        class_2338 pulley1 = util.grid().at(3, 4, 1);
        class_2338 pulley2 = util.grid().at(3, 4, 3);
        class_2338 pulley3 = util.grid().at(1, 4, 3);
        Selection contraption = util.select().fromTo(3, 1, 3, 1, 1, 1);

        ElementLink<WorldSectionElement> planksLink = scene.world().showIndependentSection(contraption, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(mainPulley, class_2350.field_11039);
        scene.idle(4);
        scene.world().showSection(util.select().position(pulley2), class_2350.field_11033);
        scene.idle(4);
        scene.world().showSection(util.select().position(pulley3), class_2350.field_11033);
        scene.idle(15);

        scene.world().movePulley(pulley1, 2, 20);
        scene.idle(20);

        scene.overlay().showText(60).pointAt(util.vector().topOf(util.grid().at(3, 1, 1))).placeNearTarget()
            .text("Whenever a pulley assembles a contraption...");
        scene.idle(70);

        scene.world().movePulley(pulley2, 2, 0);
        scene.world().movePulley(pulley3, 2, 0);
        scene.idle(1);
        scene.world().movePulley(pulley1, -2, 20);
        scene.world().movePulley(pulley2, -2, 20);
        scene.world().movePulley(pulley3, -2, 20);
        scene.world().moveSection(planksLink, util.vector().of(0, 2, 0), 20);
        scene.idle(20);

        scene.overlay().showText(80).pointAt(util.vector().blockSurface(util.grid().at(1, 4, 3), class_2350.field_11039)).placeNearTarget()
            .text("...other pulleys on the same layer will connect to the structure");
        scene.idle(60);

        scene.world().movePulley(pulley1, 2, 20);
        scene.world().movePulley(pulley2, 2, 20);
        scene.world().movePulley(pulley3, 2, 20);
        scene.world().moveSection(planksLink, util.vector().of(0, -2, 0), 20);
        scene.idle(20);

        scene.idle(20);
        scene.world().movePulley(pulley1, -2, 20);
        scene.world().movePulley(pulley2, -2, 20);
        scene.world().movePulley(pulley3, -2, 20);
        scene.world().moveSection(planksLink, util.vector().of(0, 2, 0), 20);
        scene.idle(20);

        scene.overlay().showText(80).pointAt(util.vector().blockSurface(util.grid().at(1, 4, 3), class_2350.field_11039)).placeNearTarget()
            .text("They do not require to be powered, the effect is purely cosmetic");
        scene.idle(60);

        scene.world().movePulley(pulley1, 2, 20);
        scene.world().movePulley(pulley2, 2, 20);
        scene.world().movePulley(pulley3, 2, 20);
        scene.world().moveSection(planksLink, util.vector().of(0, -2, 0), 20);
        scene.idle(20);

    }

}