package com.zurrtum.create.client.infrastructure.ponder.scenes.fluid;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.fluids.pipes.FluidPipeBlock;
import com.zurrtum.create.content.fluids.pipes.GlassFluidPipeBlock;
import com.zurrtum.create.content.fluids.pump.PumpBlock;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.CogWheelBlock;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class PumpScenes {

    public static void flow(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_pump_flow", "Fluid Transportation using Mechanical Pumps");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world().multiplyKineticSpeed(util.select().everywhere(), -1);
        scene.idle(5);

        class_2338 pumpPos = util.grid().at(2, 1, 1);
        Selection tank1 = util.select().fromTo(0, 2, 3, 0, 1, 3);
        Selection tank2 = util.select().fromTo(4, 2, 3, 4, 1, 3);
        Selection pipes = util.select().fromTo(3, 1, 3, 1, 1, 1);
        Selection largeCog = util.select().position(5, 0, 1);
        Selection kinetics = util.select().fromTo(5, 1, 0, 2, 1, 0);
        class_2338 leverPos = util.grid().at(4, 2, 0);
        Selection pump = util.select().position(pumpPos);

        scene.world().setBlock(pumpPos, AllBlocks.FLUID_PIPE.getAxisState(class_2351.field_11048), false);

        scene.world().showSection(tank1, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(tank2, class_2350.field_11033);
        scene.idle(5);
        scene.world().showSection(pipes, class_2350.field_11043);
        scene.idle(15);

        scene.world().destroyBlock(pumpPos);
        scene.world().restoreBlocks(pump);
        scene.world().modifyBlock(pumpPos, s -> s.method_11657(PumpBlock.FACING, s.method_11654(PumpBlock.FACING).method_10153()), false);
        scene.world().setKineticSpeed(pump, 0);

        scene.idle(15);

        scene.overlay().showText(60).text("Mechanical Pumps govern the flow of their attached pipe networks").attachKeyFrame().placeNearTarget()
            .pointAt(util.vector().topOf(pumpPos));

        scene.idle(70);
        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(kinetics, class_2350.field_11035);
        scene.world().showSection(util.select().position(leverPos), class_2350.field_11035);
        scene.idle(10);
        scene.world().setKineticSpeed(pump, 64);
        scene.world().propagatePipeChange(pumpPos);
        scene.effects().rotationDirectionIndicator(pumpPos.method_10095());
        scene.idle(15);

        scene.overlay().showText(60).text("Their arrow indicates the direction of flow").attachKeyFrame().placeNearTarget()
            .pointAt(util.vector().topOf(pumpPos).method_1023(0.5f, 0.125f, 0));

        class_238 bb1 = new class_238(class_243.field_1353, class_243.field_1353).method_1009(.25, .25, 0).method_989(0, 0, .25);
        class_238 bb2 = new class_238(class_243.field_1353, class_243.field_1353).method_1009(.25, .25, 1.25);
        scene.idle(65);

        Object in = new Object();
        Object out = new Object();

        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb1.method_997(util.vector().centerOf(3, 1, 3)), 3);
        scene.idle(2);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb2.method_997(util.vector().centerOf(3, 1, 2)), 50);
        scene.idle(10);

        scene.overlay().showText(50).text("The network behind is now pulling fluids...").attachKeyFrame().placeNearTarget()
            .colored(PonderPalette.INPUT).pointAt(util.vector().centerOf(3, 1, 2));

        scene.idle(60);

        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb1.method_997(util.vector().centerOf(1, 1, 1).method_1031(0, 0, -.5)), 3);
        scene.idle(2);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb2.method_997(util.vector().centerOf(1, 1, 2)), 50);
        scene.idle(10);

        scene.overlay().showText(50).text("...while the network in front is transferring it outward").placeNearTarget().colored(PonderPalette.OUTPUT)
            .pointAt(util.vector().centerOf(1, 1, 2));

        scene.idle(70);
        scene.world().toggleRedstonePower(util.select().fromTo(4, 2, 0, 4, 1, 0));
        scene.effects().indicateRedstone(leverPos);
        scene.world().multiplyKineticSpeed(util.select().fromTo(3, 1, 0, 2, 1, 1), -1);
        scene.effects().rotationDirectionIndicator(pumpPos.method_10095());
        scene.world().propagatePipeChange(pumpPos);
        scene.idle(15);

        scene.overlay().showText(60).text("The pumps direction is unaffected by the input rotation").colored(PonderPalette.RED).placeNearTarget()
            .attachKeyFrame().pointAt(util.vector().topOf(pumpPos).method_1023(0.5f, 0.125f, 0));

        scene.idle(25);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, in, new class_238(leverPos.method_10074()), 30);
        scene.idle(45);

        scene.overlay().showControls(util.vector().topOf(pumpPos), Pointing.DOWN, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(pumpPos, s -> s.method_11657(PumpBlock.FACING, class_2350.field_11034), true);
        scene.overlay().showText(70).attachKeyFrame().pointAt(util.vector().centerOf(2, 1, 1)).placeNearTarget()
            .text("Instead, a Wrench can be used to reverse the direction");
        scene.world().propagatePipeChange(pumpPos);
        scene.idle(40);

        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb1.method_997(util.vector().centerOf(3, 1, 3)), 3);
        scene.idle(2);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.INPUT, in, bb2.method_997(util.vector().centerOf(3, 1, 2)), 30);
        scene.idle(15);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb1.method_997(util.vector().centerOf(1, 1, 1).method_1031(0, 0, -.5)), 3);
        scene.idle(2);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, bb2.method_997(util.vector().centerOf(1, 1, 2)), 30);
        scene.idle(25);

    }

    public static void speed(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("mechanical_pump_speed", "Throughput of Mechanical Pumps");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        //		scene.world().showSection(util.select.layersFrom(1), Direction.DOWN);

        Selection largeCog = util.select().position(5, 0, 3);
        Selection cogs = util.select().fromTo(5, 1, 4, 2, 1, 4).add(util.select().position(2, 1, 3));
        class_2338 pumpPos = util.grid().at(2, 1, 2);
        Selection pump = util.select().position(pumpPos);
        Selection tank1 = util.select().fromTo(4, 1, 2, 4, 2, 2);
        Selection tank2 = util.select().fromTo(0, 1, 2, 0, 2, 2);
        Selection megapipe1 = util.select().fromTo(0, 3, 5, 1, 4, 2);
        Selection megapipe2 = util.select().fromTo(3, 3, 1, 5, 6, 2);

        scene.world().modifyBlock(pumpPos, s -> s.method_11657(PumpBlock.FACING, class_2350.field_11039), false);
        scene.world().modifyBlockEntity(util.grid().at(0, 1, 2), FluidTankBlockEntity.class, be -> be.getTankInventory().extractAny(243000));
        scene.world().multiplyKineticSpeed(util.select().everywhere(), 0.125f);

        class_2338 east = pumpPos.method_10078();
        scene.world().setBlock(east, class_2246.field_10124.method_9564(), false);
        scene.world().setBlock(east, AllBlocks.GLASS_FLUID_PIPE.method_9564().method_11657(GlassFluidPipeBlock.field_11459, class_2351.field_11048), false);

        scene.world().setBlock(pumpPos.method_10072(), AllBlocks.COGWHEEL.method_9564().method_11657(CogWheelBlock.AXIS, class_2351.field_11048), false);
        Selection southPump = util.select().position(pumpPos.method_10072());
        scene.world().setKineticSpeed(southPump, 4);

        scene.world().setKineticSpeed(pump, 0);
        scene.world().showSection(pump, class_2350.field_11033);
        scene.idle(10);
        ElementLink<WorldSectionElement> mp1 = scene.world().showIndependentSection(megapipe1, class_2350.field_11034);
        scene.world().moveSection(mp1, util.vector().of(0, -3, 0), 0);
        scene.idle(5);
        ElementLink<WorldSectionElement> mp2 = scene.world().showIndependentSection(megapipe2, class_2350.field_11039);
        scene.world().moveSection(mp2, util.vector().of(0, -3, 0), 0);
        scene.idle(15);

        scene.overlay().showText(70).attachKeyFrame().pointAt(util.vector().topOf(pumpPos)).placeNearTarget()
            .text("Regardless of speed, Mechanical Pumps affect pipes connected up to 16 blocks away");
        scene.idle(75);

        scene.world().hideIndependentSection(mp1, class_2350.field_11039);
        scene.idle(5);
        scene.world().hideIndependentSection(mp2, class_2350.field_11034);
        scene.idle(15);

        scene.world().showSection(tank1, class_2350.field_11033);
        scene.idle(2);
        scene.world().showSection(util.select().position(east), class_2350.field_11033);
        scene.idle(5);
        class_2338 west = pumpPos.method_10067();
        scene.world().showSection(util.select().position(west), class_2350.field_11033);
        scene.idle(2);
        scene.world().showSection(tank2, class_2350.field_11033);
        scene.idle(5);

        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.world().showSection(cogs, class_2350.field_11035);
        scene.idle(10);
        scene.world().setKineticSpeed(util.select().position(pumpPos), -4);
        scene.effects().rotationSpeedIndicator(pumpPos);
        scene.world().propagatePipeChange(pumpPos);
        scene.idle(40);

        scene.world().multiplyKineticSpeed(util.select().everywhere(), 8);
        scene.effects().rotationSpeedIndicator(pumpPos);
        scene.world().propagatePipeChange(pumpPos);
        scene.idle(20);

        scene.overlay().showText(60).attachKeyFrame().pointAt(util.vector().topOf(pumpPos)).placeNearTarget()
            .text("Speeding up the input rotation changes the speed of flow propagation...");
        scene.idle(70);

        scene.overlay().showText(50).pointAt(util.vector().blockSurface(util.grid().at(0, 1, 2), class_2350.field_11039)).placeNearTarget()
            .text("...and the speed at which fluids are transferred");
        scene.idle(60);

        class_2680 pipeState = AllBlocks.FLUID_PIPE.method_9564().method_11657(FluidPipeBlock.field_11330, false).method_11657(FluidPipeBlock.field_11327, false);
        scene.world().setKineticSpeed(util.select().everywhere(), 0);
        scene.idle(10);

        scene.world().setBlock(east, pipeState, true);
        scene.world().setBlock(west, pipeState, true);

        scene.world().setBlock(east.method_10095(), pipeState.method_11657(FluidPipeBlock.field_11332, false).method_11657(FluidPipeBlock.field_11335, false), false);
        scene.world().setBlock(east.method_10072(), pipeState.method_11657(FluidPipeBlock.field_11331, false).method_11657(FluidPipeBlock.field_11335, false), false);
        scene.world().showSection(util.select().position(east.method_10095()), class_2350.field_11033);
        scene.world().showSection(util.select().position(east.method_10072()), class_2350.field_11033);
        Selection northPump = util.select().position(pumpPos.method_10095());

        scene.world().setBlock(west.method_10095(), pipeState.method_11657(FluidPipeBlock.field_11332, false).method_11657(FluidPipeBlock.field_11328, false), false);
        scene.world().setBlock(west.method_10072(), pipeState.method_11657(FluidPipeBlock.field_11331, false).method_11657(FluidPipeBlock.field_11328, false), false);
        scene.world().showSection(util.select().position(west.method_10095()), class_2350.field_11033);
        scene.world().showSection(util.select().position(west.method_10072()), class_2350.field_11033);

        scene.world().restoreBlocks(southPump);
        scene.world().modifyBlock(pumpPos.method_10072(), s -> s.method_11657(PumpBlock.FACING, class_2350.field_11039), true);
        scene.world().setKineticSpeed(util.select().everywhere(), 0);
        scene.world().showSection(northPump, class_2350.field_11033);
        scene.world().modifyBlock(pumpPos.method_10095(), s -> s.method_11657(PumpBlock.FACING, class_2350.field_11034), false);
        scene.idle(4);

        scene.world().setKineticSpeed(util.select().everywhere(), -16);
        scene.world().setKineticSpeed(northPump, 16);
        scene.world().setKineticSpeed(southPump, 16);
        scene.world().setKineticSpeed(largeCog, 8);
        scene.idle(20);

        scene.overlay().showOutlineWithText(util.select().fromTo(2, 1, 1, 2, 1, 3), 60).attachKeyFrame().colored(PonderPalette.GREEN)
            .pointAt(util.vector().topOf(pumpPos)).placeNearTarget().text("Pumps can combine their throughputs within shared pipe networks");
        scene.idle(70);

        scene.idle(30);
        scene.overlay().showControls(util.vector().topOf(pumpPos.method_10095()), Pointing.DOWN, 30).rightClick()
            .withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().modifyBlock(pumpPos.method_10095(), s -> s.method_11657(PumpBlock.FACING, class_2350.field_11039), true);
        scene.idle(30);

        scene.overlay().showText(70).attachKeyFrame().pointAt(util.vector().topOf(pumpPos.method_10095()).method_1023(0.5f, 0.125f, 0)).placeNearTarget()
            .text("Ensure that all of them are facing in the same direction");
        scene.idle(40);

        scene.world().multiplyKineticSpeed(util.select().everywhere(), 4);
        scene.effects().rotationSpeedIndicator(pumpPos);
        scene.effects().rotationSpeedIndicator(pumpPos.method_10095());
        scene.effects().rotationSpeedIndicator(pumpPos.method_10072());
        scene.world().propagatePipeChange(pumpPos);
        scene.world().propagatePipeChange(pumpPos.method_10095());
        scene.world().propagatePipeChange(pumpPos.method_10072());
        scene.idle(100);

        scene.world().multiplyKineticSpeed(util.select().everywhere(), -1);
        scene.effects().rotationSpeedIndicator(pumpPos);
        scene.effects().rotationSpeedIndicator(pumpPos.method_10095());
        scene.effects().rotationSpeedIndicator(pumpPos.method_10072());
        scene.world().propagatePipeChange(pumpPos);
        scene.world().propagatePipeChange(pumpPos.method_10095());
        scene.world().propagatePipeChange(pumpPos.method_10072());
    }

}