package com.zurrtum.create.client.infrastructure.ponder.scenes.highLogistics;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ParrotPose.FacePointOfInterestPose;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlock;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.zurrtum.create.infrastructure.component.AutoRequestData;
import com.zurrtum.create.infrastructure.component.PackageOrderWithCrafts;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class TableClothScenes {

    public static void tableCloth(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("table_cloth", "Selling items with Table Cloths");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.925f);
        scene.setSceneOffsetY(-0.5f);
        scene.showBasePlate();

        Selection initialCloth = util.select().fromTo(3, 1, 3, 3, 2, 3);
        Selection scaff1 = util.select().position(5, 1, 1);
        Selection cloth1 = util.select().position(5, 2, 1);
        Selection vault = util.select().fromTo(4, 1, 4, 3, 3, 5);
        Selection packScaff = util.select().position(2, 1, 4);
        class_2338 pack = util.grid().at(2, 2, 4);
        Selection packager = util.select().position(2, 2, 4);
        class_2338 link = util.grid().at(2, 3, 4);
        Selection linkS = util.select().position(2, 3, 4);
        Selection funnel = util.select().position(1, 2, 4);
        Selection belt = util.select().fromTo(1, 1, 5, 1, 1, 0);
        Selection largeCog = util.select().position(2, 0, 7);
        Selection cogs = util.select().fromTo(2, 1, 5, 2, 1, 6);
        Selection ticker = util.select().position(3, 1, 1);
        Selection seat = util.select().position(3, 1, 2);

        scene.idle(10);

        scene.world().showSection(initialCloth, class_2350.field_11033);
        scene.idle(15);

        class_1799 grass = new class_1799(class_1802.field_8583);
        scene.overlay().showControls(util.vector().centerOf(3, 2, 3), Pointing.DOWN, 50).rightClick().withItem(grass);

        scene.idle(7);
        scene.effects().indicateSuccess(util.grid().at(3, 2, 3));
        scene.world().cycleBlockProperty(util.grid().at(3, 2, 3), TableClothBlock.HAS_BE);
        scene.world().modifyBlockEntity(util.grid().at(3, 2, 3), TableClothBlockEntity.class, be -> be.manuallyAddedItems.add(grass));
        scene.idle(10);

        scene.overlay().showText(60).text("Table cloths can be used to display items").attachKeyFrame().pointAt(util.vector().topOf(3, 1, 3))
            .placeNearTarget();
        scene.idle(70);

        scene.effects().indicateSuccess(util.grid().at(3, 2, 3));
        scene.world().modifyBlockEntity(
            util.grid().at(3, 2, 3), TableClothBlockEntity.class, be -> {
                AutoRequestData.Mutable mutable = new AutoRequestData.Mutable();
                mutable.encodedRequest = PackageOrderWithCrafts.simple(List.of(new BigItemStack(grass)));
                mutable.isValid = true;
                be.requestData = mutable.toImmutable();
                be.priceTag.setFilter(new class_1799(class_1802.field_8477));
                be.priceTag.count = 1;
                be.facing = class_2350.field_11043;
            }
        );

        scene.overlay().showText(100).text("With the help of a logistics system, they can also be used to sell items").attachKeyFrame()
            .pointAt(util.vector().of(3, 1.75, 3)).placeNearTarget();
        scene.idle(110);

        scene.world().hideSection(initialCloth, class_2350.field_11036);
        scene.idle(20);
        scene.world().showSection(vault, class_2350.field_11043);
        scene.world().showSection(packScaff, class_2350.field_11043);
        scene.idle(10);
        scene.world().showSection(packager, class_2350.field_11034);
        scene.idle(10);
        scene.world().showSection(linkS, class_2350.field_11033);

        scene.overlay().showOutlineWithText(util.select().fromTo(3, 2, 4, 4, 3, 5), 100)
            .text("Start with the shop's inventory, a Packager and Stock link").attachKeyFrame().colored(PonderPalette.BLUE)
            .pointAt(util.vector().of(2, 3, 4)).placeNearTarget();
        scene.idle(110);

        class_1799 tickerItem = AllItems.STOCK_TICKER.method_7854();
        scene.overlay().showControls(util.vector().centerOf(2, 3, 4), Pointing.DOWN, 80).rightClick().withItem(tickerItem);
        scene.idle(5);

        class_238 bb1 = new class_238(link);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, link, bb1.method_1011(0.45), 10);
        scene.idle(1);
        bb1 = bb1.method_1011(1 / 16f).method_1002(0, 8 / 16f, 0);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLUE, link, bb1, 50);
        scene.idle(26);

        scene.overlay().showText(80).text("Bind a Stock ticker to the link and place it in the shop").attachKeyFrame().colored(PonderPalette.BLUE)
            .pointAt(util.vector().centerOf(link)).placeNearTarget();
        scene.idle(70);

        scene.world().showSection(ticker, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(seat, class_2350.field_11043);
        scene.idle(10);
        scene.special().createBirb(util.vector().centerOf(util.grid().at(3, 1, 2)), FacePointOfInterestPose::new);
        scene.idle(20);

        scene.overlay().showText(90).text("Employ a mob or blaze burner as the shop keeper").attachKeyFrame()
            .pointAt(util.vector().of(2.5, 2.75, 1.5)).placeNearTarget();
        scene.idle(100);

        class_1799 logItem1 = new class_1799(class_1802.field_8583);
        class_1799 logItem2 = new class_1799(class_1802.field_8170);
        scene.overlay().showControls(util.vector().of(5, 3.5, 4), Pointing.RIGHT, 80).withItem(logItem1);
        scene.overlay().showControls(util.vector().of(5, 2, 4), Pointing.RIGHT, 80).withItem(logItem2);
        scene.idle(10);

        scene.overlay().showText(70).text("Fill the shop inventory with items to be sold").attachKeyFrame().pointAt(util.vector().of(4, 3, 4))
            .placeNearTarget();
        scene.idle(80);

        class_1799 clothItem = AllItems.LIGHT_GRAY_TABLE_CLOTH.method_7854();
        scene.overlay().showControls(util.vector().of(3, 3, 1.75), Pointing.DOWN, 120).rightClick().withItem(clothItem);
        scene.idle(30);

        scene.overlay().showText(100).text("To create a new trade, interact with the shop keeper while holding a table cloth").attachKeyFrame()
            .pointAt(util.vector().of(2.5, 2.75, 1.5)).placeNearTarget();
        scene.idle(100);

        scene.world().cycleBlockProperty(util.grid().at(5, 2, 1), TableClothBlock.HAS_BE);
        scene.world().modifyBlockEntity(
            util.grid().at(5, 2, 1), TableClothBlockEntity.class, be -> {
                AutoRequestData.Mutable mutable = new AutoRequestData.Mutable();
                mutable.encodedRequest = PackageOrderWithCrafts.simple(List.of(new BigItemStack(logItem1)));
                mutable.isValid = true;
                be.requestData = mutable.toImmutable();
                be.facing = class_2350.field_11043;
            }
        );

        scene.world().showSection(scaff1, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(cloth1, class_2350.field_11033);
        scene.idle(20);

        class_1799 diamondItem = new class_1799(class_1802.field_8477);
        class_243 filterSlot = util.vector().of(5.25, 1.825, 1);
        scene.overlay().showControls(filterSlot, Pointing.DOWN, 120).rightClick().withItem(diamondItem);
        scene.idle(5);
        scene.world().setFilterData(util.select().position(5, 2, 1), TableClothBlockEntity.class, diamondItem);
        scene.idle(15);

        scene.overlay().showText(90).text("Once placed, set a price in the item slot on the side").attachKeyFrame().pointAt(filterSlot)
            .placeNearTarget();
        scene.idle(120);

        scene.overlay().showControls(util.vector().centerOf(util.grid().at(5, 2, 1)), Pointing.DOWN, 90).rightClick();
        scene.idle(10);

        scene.overlay().showText(90).text("Other players can now interact with the shop").attachKeyFrame().pointAt(util.vector().of(5, 2, 1.5))
            .placeNearTarget();
        scene.idle(100);

        class_1799 listItem = AllItems.SHOPPING_LIST.method_7854();
        scene.overlay().showControls(util.vector().of(3, 3, 1.75), Pointing.DOWN, 90).rightClick().withItem(listItem);
        scene.idle(5);
        scene.effects().indicateSuccess(util.grid().at(3, 1, 1));
        PonderHilo.linkEffect(scene, link);
        class_1799 box = PackageItem.containing(List.of());
        PonderHilo.packagerCreate(scene, pack, box);
        scene.idle(30);

        scene.overlay().showText(120).text("When checking out at the cashier, the bought items will be placed into a package").attachKeyFrame()
            .pointAt(util.vector().of(2.5, 2.5, 4)).placeNearTarget();
        scene.idle(100);

        scene.world().showSection(largeCog, class_2350.field_11036);
        scene.idle(3);
        scene.world().showSection(cogs, class_2350.field_11033);
        scene.idle(3);
        scene.world().showSection(belt, class_2350.field_11034);
        scene.idle(5);
        scene.world().showSection(funnel, class_2350.field_11033);
        scene.idle(15);
        scene.world().createItemOnBelt(util.grid().at(1, 1, 4), class_2350.field_11034, box);
        PonderHilo.packagerClear(scene, pack);
        scene.idle(45);

        scene.overlay().showText(90).text("From there, they can be transported to the shop front").attachKeyFrame()
            .pointAt(util.vector().of(1, 2.5, 1.5)).placeNearTarget();
        scene.idle(100);

        scene.overlay().showControls(util.vector().topOf(util.grid().at(3, 1, 1)), Pointing.DOWN, 100).rightClick().withItem(diamondItem);
        scene.idle(10);

        scene.overlay().showText(90).text("The payments will be stored inside the stock ticker block").attachKeyFrame()
            .pointAt(util.vector().centerOf(util.grid().at(3, 1, 1))).placeNearTarget();
        scene.idle(100);

    }

}