package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.flywheel.impl.visualization.VisualizationManagerImpl;
import com.zurrtum.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_2818;
import net.minecraft.class_4076;
import net.minecraft.class_631;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_631.class)
public class ClientChunkManagerMixin {
    @Shadow
    @Final
    class_638 world;

    @Inject(method = "onLightUpdate", at = @At("HEAD"))
    private void flywheel$onLightUpdate(class_1944 type, class_4076 pos, CallbackInfo ci) {
        var manager = VisualizationManagerImpl.get(world);

        if (manager != null) {
            manager.onLightUpdate(pos, type);
        }
    }

    @Inject(method = "unload(Lnet/minecraft/util/math/ChunkPos;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/world/ClientChunkManager$ClientChunkMap;unloadChunk(ILnet/minecraft/world/chunk/WorldChunk;)V"))
    private void unload(class_1923 pos, CallbackInfo ci, @Local class_2818 chunk) {
        CapabilityMinecartController.onChunkUnloaded(chunk);
    }
}
