package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import net.caffeinemc.mods.sodium.fabric.model.FabricModelAccess;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;

@Mixin(FabricModelAccess.class)
public class FabricModelAccessMixin {
    @WrapOperation(method = "collectPartsOf(Lnet/minecraft/client/render/model/BlockStateModel;Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/random/Random;Lnet/fabricmc/fabric/api/renderer/v1/mesh/QuadEmitter;)Ljava/util/List;", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/model/BlockStateModel;addParts(Lnet/minecraft/util/math/random/Random;Ljava/util/List;)V"))
    private void addParts(
        class_1087 model,
        class_5819 random,
        List<class_10889> parts,
        Operation<Void> original,
        @Local(argsOnly = true) class_1920 world,
        @Local(argsOnly = true) class_2338 pos,
        @Local(argsOnly = true) class_2680 state
    ) {
        if (WrapperBlockStateModel.unwrapCompat(model) instanceof WrapperBlockStateModel wrapper) {
            wrapper.addPartsWithInfo(world, pos, state, random, parts);
        } else {
            original.call(model, random, parts);
        }
    }
}
