package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.serialization.Dynamic;
import com.zurrtum.create.infrastructure.worldgen.AllPlacedFeatures;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_6904;
import net.minecraft.class_7196;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_7196.class)
public class IntegratedServerLoaderMixin {
    @WrapOperation(method = "start(Lnet/minecraft/world/level/storage/LevelStorage$Session;Lcom/mojang/serialization/Dynamic;ZLjava/lang/Runnable;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/integrated/IntegratedServerLoader;load(Lcom/mojang/serialization/Dynamic;ZLnet/minecraft/resource/ResourcePackManager;)Lnet/minecraft/server/SaveLoader;"))
    private class_6904 addBiomeFeatures(
        class_7196 instance,
        Dynamic<?> levelProperties,
        boolean safeMode,
        class_3283 dataPackManager,
        Operation<class_6904> original
    ) {
        class_6904 loader = original.call(instance, levelProperties, safeMode, dataPackManager);
        AllPlacedFeatures.register(loader.comp_358().method_45926());
        return loader;
    }

    @WrapOperation(method = "startNewWorld(Lnet/minecraft/world/level/storage/LevelStorage$Session;Lnet/minecraft/server/DataPackContents;Lnet/minecraft/registry/CombinedDynamicRegistries;Lnet/minecraft/world/SaveProperties;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/MinecraftClient;startIntegratedServer(Lnet/minecraft/world/level/storage/LevelStorage$Session;Lnet/minecraft/resource/ResourcePackManager;Lnet/minecraft/server/SaveLoader;Z)V"))
    private void addBiomeFeatures(
        class_310 instance,
        class_32.class_5143 session,
        class_3283 dataPackManager,
        class_6904 saveLoader,
        boolean newWorld,
        Operation<Void> original
    ) {
        AllPlacedFeatures.register(saveLoader.comp_358().method_45926());
        original.call(instance, session, dataPackManager, saveLoader, newWorld);
    }
}
