/*
 * Copyright (c) NeoForged and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package com.zurrtum.create.client.model;

import net.minecraft.class_10352;
import net.minecraft.class_10419;
import net.minecraft.class_10813;
import net.minecraft.class_10817;
import net.minecraft.class_10820;
import net.minecraft.class_3665;
import net.minecraft.class_7775;
import net.minecraft.client.render.model.*;

/**
 * Base interface for unbaked models that wish to support the NeoForge-added {@code bake} method
 */
@FunctionalInterface
public interface ExtendedUnbakedGeometry extends class_10820 {
    class_10352 EMPTY = new class_10352.class_10353().method_64971(NeoForgeModelProperties.EMPTY_TYPE);

    @Override
    default class_10817 bake(class_10419 p_405831_, class_7775 p_405026_, class_3665 p_405122_, class_10813 p_405635_) {
        return bake(p_405831_, p_405026_, p_405122_, p_405635_, EMPTY);
    }

    // Re-abstract the extended version
    class_10817 bake(
        class_10419 textureSlots,
        class_7775 baker,
        class_3665 state,
        class_10813 debugName,
        class_10352 additionalProperties
    );
}
