package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_243;

public class AnimateParrotInstruction extends AnimateElementInstruction<ParrotElement> {

    public static AnimateParrotInstruction rotate(ElementLink<ParrotElement> link, class_243 rotation, int ticks) {
        return new AnimateParrotInstruction(link, rotation, ticks, (wse, v) -> wse.setRotation(v, ticks == 0), ParrotElement::getRotation);
    }

    public static AnimateParrotInstruction move(ElementLink<ParrotElement> link, class_243 offset, int ticks) {
        return new AnimateParrotInstruction(link, offset, ticks, (wse, v) -> wse.setPositionOffset(v, ticks == 0), ParrotElement::getPositionOffset);
    }

    protected AnimateParrotInstruction(
        ElementLink<ParrotElement> link,
        class_243 totalDelta,
        int ticks,
        BiConsumer<ParrotElement, class_243> setter,
        Function<ParrotElement, class_243> getter
    ) {
        super(link, totalDelta, ticks, setter, getter);
    }

}