package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.element.AnimatedSceneElement;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.ElementLinkImpl;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public abstract class FadeIntoSceneInstruction<T extends AnimatedSceneElement> extends TickingInstruction {

    protected class_2350 fadeInFrom;
    protected T element;
    private ElementLink<T> elementLink;

    public FadeIntoSceneInstruction(int fadeInTicks, class_2350 fadeInFrom, T element) {
        super(false, fadeInTicks);
        this.fadeInFrom = fadeInFrom;
        this.element = element;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        scene.addElement(element);
        element.setVisible(true);
        element.setFade(0);
        element.setFadeVec(fadeInFrom == null ? class_243.field_1353 : class_243.method_24954(fadeInFrom.method_62675()).method_1021(.5f));
        if (elementLink != null)
            scene.linkElement(element, elementLink);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        float fade = totalTicks == 0 ? 1 : (remainingTicks / (float) totalTicks);
        element.setFade(1 - fade * fade);
        if (remainingTicks == 0) {
            if (totalTicks == 0)
                element.setFade(1);
            element.setFade(1);
        }
    }

    public ElementLink<T> createLink(PonderScene scene) {
        elementLink = new ElementLinkImpl<>(getElementClass());
        scene.linkElement(element, elementLink);
        return elementLink;
    }

    protected abstract Class<T> getElementClass();

}