package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.EntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBuilder;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.vanillin.item.ItemModels;
import net.minecraft.class_10811;
import net.minecraft.class_1087;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_765;
import net.minecraft.class_811;
import org.joml.Matrix4f;

public class ItemFrameVisual extends AbstractVisual implements EntityVisual<class_1533>, SimpleDynamicVisual {
    public static final RendererReloadCache<class_1087, Model> MODEL_RESOURCE_LOCATION = new RendererReloadCache<>(model -> new BakedModelBuilder(
        model).build());

    private final Matrix4f baseTransform = new Matrix4f();

    private final TransformedInstance frame;
    private final TransformedInstance item;
    private final class_1533 entity;
    private class_1087 lastFrameModel;
    private class_1799 lastItemStack;

    public ItemFrameVisual(VisualizationContext ctx, class_1533 entity, float partialTick) {
        super(ctx, entity.method_73183(), partialTick);

        this.entity = entity;

        lastItemStack = entity.method_6940().method_7972();

        lastFrameModel = getFrameModel();
        var frameModel = MODEL_RESOURCE_LOCATION.get(lastFrameModel);

        frame = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, frameModel).createInstance();

        frame.setTransform(baseTransform);

        item = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(level, lastItemStack, class_811.field_4319))
            .createInstance();

        animate(partialTick);
    }

    public static boolean shouldVisualize(class_1533 entity) {
        // We don't support map rendering, and we can't support exotic item models.
        return !entity.method_6940().method_31574(class_1802.field_8204) && ItemModels.isSupported(entity.method_6940(), class_811.field_4319);
    }

    @Override
    public void beginFrame(Context ctx) {
        animate(ctx.partialTick());
    }

    public void animate(float partialTick) {
        var light = class_765.method_23687(getBlockLightLevel(entity.method_24515()), getSkyLightLevel(entity.method_24515()));

        boolean invisible = entity.method_5767();

        class_2350 direction = entity.method_5735();
        var origin = visualizationContext.renderOrigin();

        float d = 0.46875f;

        float x = (float) (entity.method_23317() - origin.method_10263() + direction.method_10148() * d);
        float y = (float) (entity.method_23318() - origin.method_10264() + direction.method_10164() * d);
        float z = (float) (entity.method_23321() - origin.method_10260() + direction.method_10165() * d);

        baseTransform.translation(x, y, z);
        baseTransform.rotateXYZ(class_3532.field_29847 * entity.method_36455(), class_3532.field_29847 * (180.0f - entity.method_36454()), 0.0f);

        var stack = entity.method_6940();
        var frameLocation = getFrameModel();

        if (frameLocation != lastFrameModel) {
            visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MODEL_RESOURCE_LOCATION.get(frameLocation))
                .stealInstance(frame);
            lastFrameModel = frameLocation;
        }

        frame.setVisible(!invisible);

        frame.setTransform(baseTransform).translate(-0.5f, -0.5f, -0.5f).light(light).setChanged();

        if (!class_1799.method_7973(lastItemStack, stack)) {
            lastItemStack = stack.method_7972();
            visualizationContext.instancerProvider()
                .instancer(InstanceTypes.TRANSFORMED, ItemModels.get(level, lastItemStack, class_811.field_4319)).stealInstance(item);
        }

        item.setTransform(baseTransform);

        if (invisible) {
            item.translate(0.0F, 0.0F, 0.5F);
        } else {
            item.translate(0.0F, 0.0F, 0.4375F);
        }

        int i = entity.method_43273() ? entity.method_6934() % 4 * 2 : entity.method_6934();

        item.rotateZDegrees(i * 360.0F / 8.0F);

        item.scale(0.5F, 0.5F, 0.5F);

        item.light(getLightVal(light)).setChanged();
    }

    @Override
    public void update(float partialTick) {

    }

    @Override
    protected void _delete() {
        frame.delete();
        item.delete();
    }

    private int getLightVal(int regularLightVal) {
        return entity.method_5864() == class_1299.field_28401 ? 15728880 : regularLightVal;
    }

    protected int getSkyLightLevel(class_2338 pos) {
        return level.method_8314(class_1944.field_9284, pos);
    }

    protected int getBlockLightLevelBase(class_2338 pos) {
        return entity.method_5809() ? 15 : level.method_8314(class_1944.field_9282, pos);
    }

    protected int getBlockLightLevel(class_2338 pos) {
        return entity.method_5864() == class_1299.field_28401 ? Math.max(5, getBlockLightLevelBase(pos)) : getBlockLightLevelBase(pos);
    }

    public class_1087 getFrameModel() {
        boolean bl = entity.method_5864() == class_1299.field_28401;
        class_2680 state = class_10811.method_68014(bl, false);
        return class_310.method_1551().method_1541().method_3349(state);
    }
}
