package com.zurrtum.create.compat.rei;

import com.zurrtum.create.content.processing.recipe.SizedIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import dev.architectury.fluid.FluidStack;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.FabricIngredient;
import net.fabricmc.fabric.impl.recipe.ingredient.builtin.ComponentsIngredient;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3611;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.stream.Stream;

public interface IngredientHelper {
    static EntryIngredient createEntryIngredient(com.zurrtum.create.infrastructure.fluids.FluidStack stack) {
        return EntryIngredients.of(FluidStack.create(stack.getFluid(), stack.getAmount(), stack.getComponentChanges()));
    }

    static EntryIngredient createEntryIngredient(FluidIngredient ingredient) {
        EntryDefinition<FluidStack> definition = VanillaEntryTypes.FLUID.getDefinition();
        List<class_3611> fluids = ingredient.getMatchingFluids();
        EntryIngredient.Builder builder = EntryIngredient.builder(fluids.size());
        int amount = ingredient.amount();
        class_9326 patch = class_9326.field_49588;
        if (ingredient instanceof FluidStackIngredient stackIngredient) {
            patch = stackIngredient.components();
        }
        for (class_3611 fluid : fluids) {
            FluidStack stack = FluidStack.create(fluid, amount, patch);
            builder.add(EntryStack.of(definition, stack));
        }
        return builder.build();
    }

    static Stream<EntryIngredient> getFluidIngredientStream(@Nullable FluidIngredient ingredient) {
        return ingredient == null ? Stream.empty() : Stream.of(createEntryIngredient(ingredient));
    }

    static Stream<EntryIngredient> getFluidIngredientStream(List<FluidIngredient> ingredients) {
        if (ingredients.isEmpty()) {
            return Stream.empty();
        }
        Stream.Builder<EntryIngredient> builder = Stream.builder();
        for (FluidIngredient ingredient : ingredients) {
            builder.add(createEntryIngredient(ingredient));
        }
        return builder.build();
    }

    static Stream<EntryIngredient> getSizedIngredientStream(List<SizedIngredient> ingredients) {
        Stream.Builder<EntryIngredient> results = Stream.builder();
        EntryDefinition<class_1799> definition = VanillaEntryTypes.ITEM.getDefinition();
        int size = ingredients.size();
        for (SizedIngredient ingredient : ingredients) {
            EntryIngredient.Builder builder = EntryIngredient.builder(size);
            ingredient.getIngredient().field_9019.forEach(stack -> {
                builder.add(EntryStack.of(definition, new class_1799(stack, ingredient.getCount())));
            });
            results.add(builder.build());
        }
        return results.build();
    }

    static List<EntryIngredient> getEntryIngredients(Stream<EntryIngredient> first, Stream<EntryIngredient> second) {
        return Stream.concat(first, second).toList();
    }

    @SuppressWarnings("UnstableApiUsage")
    static EntryIngredient getInputEntryIngredient(class_1856 ingredient) {
        CustomIngredient customIngredient = ((FabricIngredient) ingredient).getCustomIngredient();
        if (customIngredient instanceof ComponentsIngredient) {
            EntryDefinition<class_1799> definition = VanillaEntryTypes.ITEM.getDefinition();
            List<class_10302> contents = ((class_10302.class_10304) customIngredient.toDisplay()).comp_3272();
            EntryIngredient.Builder builder = EntryIngredient.builder(contents.size());
            for (class_10302 content : contents) {
                class_10302.class_10307 display = (class_10302.class_10307) content;
                builder.add(EntryStack.of(definition, display.comp_3274()));
            }
            return builder.build();
        } else {
            return EntryIngredients.ofIngredient(ingredient);
        }
    }
}
