package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.kinetics.deployer.ManualApplicationRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;

public record ManualApplicationDisplay(
    EntryIngredient input, EntryIngredient target, EntryIngredient output, Optional<class_2960> location
) implements Display {
    public static final DisplaySerializer<ManualApplicationDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(ManualApplicationDisplay::input),
            EntryIngredient.codec().fieldOf("target").forGetter(ManualApplicationDisplay::target),
            EntryIngredient.codec().fieldOf("output").forGetter(ManualApplicationDisplay::output),
            class_2960.field_25139.optionalFieldOf("location").forGetter(ManualApplicationDisplay::location)
        ).apply(instance, ManualApplicationDisplay::new)), class_9139.method_56905(
            EntryIngredient.streamCodec(),
            ManualApplicationDisplay::input,
            EntryIngredient.streamCodec(),
            ManualApplicationDisplay::target,
            EntryIngredient.streamCodec(),
            ManualApplicationDisplay::output,
            class_9135.method_56382(class_2960.field_48267),
            ManualApplicationDisplay::location,
            ManualApplicationDisplay::new
        )
    );

    public ManualApplicationDisplay(class_8786<ManualApplicationRecipe> entry) {
        this(entry.comp_1932().method_29177(), entry.comp_1933());
    }

    public ManualApplicationDisplay(class_2960 id, ManualApplicationRecipe recipe) {
        this(
            EntryIngredients.ofIngredient(recipe.ingredient()),
            EntryIngredients.ofIngredient(recipe.target()),
            EntryIngredients.of(recipe.result()),
            Optional.of(id)
        );
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input, target);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.ITEM_APPLICATION;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
