package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;

public record MechanicalCraftingDisplay(
    int width, int height, List<Optional<class_1856>> inputs, EntryIngredient output, Optional<class_2960> location
) implements Display {
    public static final DisplaySerializer<MechanicalCraftingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            Codec.INT.fieldOf("width").forGetter(MechanicalCraftingDisplay::width),
            Codec.INT.fieldOf("height").forGetter(MechanicalCraftingDisplay::height),
            class_5699.method_57155(class_1856.field_46095).listOf().fieldOf("inputs").forGetter(MechanicalCraftingDisplay::inputs),
            EntryIngredient.codec().fieldOf("output").forGetter(MechanicalCraftingDisplay::output),
            class_2960.field_25139.optionalFieldOf("location").forGetter(MechanicalCraftingDisplay::location)
        ).apply(instance, MechanicalCraftingDisplay::new)), class_9139.method_56906(
            class_9135.field_48550,
            MechanicalCraftingDisplay::width,
            class_9135.field_48550,
            MechanicalCraftingDisplay::height,
            class_1856.field_52595.method_56433(class_9135.method_56363()),
            MechanicalCraftingDisplay::inputs,
            EntryIngredient.streamCodec(),
            MechanicalCraftingDisplay::output,
            class_2960.field_48267.method_56433(class_9135::method_56382),
            MechanicalCraftingDisplay::location,
            MechanicalCraftingDisplay::new
        )
    );

    public MechanicalCraftingDisplay(class_8786<MechanicalCraftingRecipe> entry) {
        this(entry.comp_1932().method_29177(), entry.comp_1933());
    }

    public MechanicalCraftingDisplay(class_2960 id, MechanicalCraftingRecipe recipe) {
        this(recipe.raw().method_59995(), recipe.raw().method_59996(), recipe.raw().method_59997(), EntryIngredients.of(recipe.result()), Optional.of(id));
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return inputs.stream().filter(Optional::isPresent).map(Optional::get).map(EntryIngredients::ofIngredient).toList();
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.MECHANICAL_CRAFTING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
