package com.zurrtum.create.content.contraptions.actors.seat;

import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1493;
import net.minecraft.class_1613;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_7102;
import net.minecraft.entity.passive.*;

public class SeatEntity extends class_1297 {

    public SeatEntity(class_1299<? extends SeatEntity> p_i48580_1_, class_1937 p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public SeatEntity(class_1937 world, class_2338 pos) {
        this(AllEntityTypes.SEAT, world);
        field_5960 = true;
    }

    @Override
    public void method_5814(double x, double y, double z) {
        super.method_23327(x, y, z);
        class_238 bb = method_5829();
        class_243 diff = new class_243(x, y, z).method_1020(bb.method_1005());
        method_5857(bb.method_997(diff));
    }

    @Override
    protected void method_5865(class_1297 pEntity, class_1297.class_4738 pCallback) {
        if (!this.method_5626(pEntity))
            return;
        double heightOffset = method_52538(pEntity).field_1351 - pEntity.method_55668(this).field_1351;

        pCallback.accept(pEntity, this.method_23317(), 1.0 / 16.0 + heightOffset + getCustomEntitySeatOffset(pEntity), this.method_23321());
    }

    public static double getCustomEntitySeatOffset(class_1297 entity) {
        if (entity instanceof class_1621)
            return 0.0f;
        if (entity instanceof class_1453)
            return 1 / 12f;
        if (entity instanceof class_1613)
            return 1 / 8f;
        if (entity instanceof class_1451)
            return 1 / 12f;
        if (entity instanceof class_1493)
            return 1 / 16f;
        if (entity instanceof class_7102)
            return 1.5 / 16f;
        if (entity instanceof class_1628)
            return 1 / 8.0;
        if (entity instanceof PackageEntity)
            return 3 / 32f;
        return 0;
    }

    @Override
    public void method_18799(class_243 p_213317_1_) {
    }

    @Override
    public void method_5773() {
        if (method_73183().method_8608())
            return;
        boolean blockPresent = method_73183().method_8320(method_24515()).method_26204() instanceof SeatBlock;
        if (method_5782() && blockPresent)
            return;
        this.method_31472();
    }

    @Override
    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }

    @Override
    protected boolean method_5860(class_1297 entity) {
        // Fake Players (tested with deployers) have a BUNCH of weird issues, don't let
        // them ride seats
        return !(FakePlayerHandler.has(entity));
    }

    @Override
    protected void method_5793(class_1297 entity) {
        super.method_5793(entity);
        if (entity instanceof class_1321 ta)
            ta.method_6179(false);
    }

    @Override
    public class_243 method_24829(class_1309 pLivingEntity) {
        return super.method_24829(pLivingEntity).method_1031(0, 0.5f, 0);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
    }

    @Override
    protected void method_5749(class_11368 view) {
    }

    @Override
    protected void method_5652(class_11372 view) {
    }
}
