package com.zurrtum.create.content.contraptions.actors.seat;

import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_9817;

public class SeatInteractionBehaviour extends MovingInteractionBehaviour {

    @Override
    public boolean handlePlayerInteraction(class_1657 player, class_1268 activeHand, class_2338 localPos, AbstractContraptionEntity contraptionEntity) {
        return false;
    }

    @Override
    public void handleEntityCollision(class_1297 entity, class_2338 localPos, AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        int index = contraption.getSeats().indexOf(localPos);
        if (index == -1)
            return;
        if (!SeatBlock.canBePickedUp(entity))
            return;
        if (entity instanceof class_9817 leashable && leashable.method_60953())
            return;
        contraptionEntity.addSittingPassenger(entity, index);
    }

}
