package com.zurrtum.create.content.contraptions.mounted;

import com.mojang.serialization.Codec;
import com.zurrtum.create.*;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.content.redstone.rail.ControllerRailBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_8942;
import net.minecraft.util.math.*;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;

public class CartAssemblerBlockEntity extends SmartBlockEntity {
    private static final int assemblyCooldown = 8;

    protected ServerScrollOptionBehaviour<CartMovementMode> movementMode;
    private int ticksSinceMinecartUpdate;
    protected AssemblyException lastException;
    protected class_1688 cartToAssemble;

    public CartAssemblerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CART_ASSEMBLER, pos, state);
        ticksSinceMinecartUpdate = assemblyCooldown;
    }

    @Override
    public void tick() {
        super.tick();
        if (ticksSinceMinecartUpdate < assemblyCooldown) {
            ticksSinceMinecartUpdate++;
        }

        tryAssemble(cartToAssemble);
        cartToAssemble = null;
    }

    public void tryAssemble(class_1688 cart) {
        if (cart == null)
            return;

        if (!isMinecartUpdateValid())
            return;
        resetTicksSinceMinecartUpdate();

        class_2680 state = field_11863.method_8320(field_11867);
        if (!state.method_27852(AllBlocks.CART_ASSEMBLER))
            return;
        CartAssemblerBlock.CartAssemblerAction action = CartAssemblerBlock.getActionForCart(state, cart);
        if (action.shouldAssemble())
            assemble(field_11863, field_11867, cart);
        if (action.shouldDisassemble())
            disassemble(field_11863, field_11867, cart);
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE) {
            if (cart.method_18798().method_1033() > 1 / 128f) {
                class_2350 facing = cart.method_5755();
                class_2768 railShape = state.method_11654(CartAssemblerBlock.RAIL_SHAPE);
                for (class_2350 d : Iterate.directionsInAxis(railShape == class_2768.field_12674 ? class_2351.field_11048 : class_2351.field_11051))
                    if (field_11863.method_8320(field_11867.method_10093(d)).method_26212(field_11863, field_11867.method_10093(d)))
                        facing = d.method_10153();

                double speed = cart.method_7504((class_3218) field_11863);
                cart.method_18800(facing.method_10148() * speed, facing.method_10164() * speed, facing.method_10165() * speed);
            }
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL) {
            class_2382 accelerationVector = ControllerRailBlock.getAccelerationVector(AllBlocks.CONTROLLER_RAIL.method_9564()
                .method_11657(ControllerRailBlock.SHAPE, state.method_11654(CartAssemblerBlock.RAIL_SHAPE))
                .method_11657(ControllerRailBlock.BACKWARDS, state.method_11654(CartAssemblerBlock.BACKWARDS)));
            double speed = cart.method_7504((class_3218) field_11863);
            cart.method_18799(class_243.method_24954(accelerationVector).method_1021(speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.DISASSEMBLE_BRAKE) {
            class_243 diff = VecHelper.getCenterOf(field_11867).method_1020(cart.method_73189());
            cart.method_18800(diff.field_1352 / 16f, 0, diff.field_1350 / 16f);
        }
    }

    protected void assemble(class_1937 world, class_2338 pos, class_1688 cart) {
        if (!cart.method_5685().isEmpty())
            return;

        Optional<MinecartController> value = AllSynchedDatas.MINECART_CONTROLLER.get(cart);
        if (value.map(MinecartController::isCoupledThroughContraption).orElse(false)) {
            return;
        }

        CartMovementMode mode = CartMovementMode.values()[movementMode.getValue()];

        MountedContraption contraption = new MountedContraption(mode);
        try {
            if (!contraption.assemble(world, pos))
                return;

            lastException = null;
            sendData();
        } catch (AssemblyException e) {
            lastException = e;
            sendData();
            return;
        }

        boolean couplingFound = contraption.connectedCart != null;
        class_2350 initialOrientation = CartAssemblerBlock.getHorizontalDirection(method_11010());

        if (couplingFound) {
            cart.method_5814(pos.method_10263() + .5f, pos.method_10264(), pos.method_10260() + .5f);
            if (!CouplingHandler.tryToCoupleCarts(null, world, cart.method_5628(), contraption.connectedCart.method_5628()))
                return;
        }

        contraption.removeBlocksFromWorld(world, class_2338.field_10980);
        contraption.startMoving(world);
        contraption.expandBoundsAroundAxis(class_2351.field_11052);

        if (couplingFound) {
            class_243 diff = contraption.connectedCart.method_73189().method_1020(cart.method_73189());
            initialOrientation = class_2350.method_10150(class_3532.method_15349(diff.field_1350, diff.field_1352) * 180 / Math.PI);
        }

        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        if (couplingFound)
            entity.setCouplingId(cart.method_5667());
        entity.method_5814(pos.method_10263() + .5, pos.method_10264(), pos.method_10260() + .5);
        world.method_8649(entity);
        entity.method_5804(cart);

        if (cart instanceof class_1696) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(method_71402(), Create.LOGGER)) {
                class_11362 view = class_11362.method_71459(logging, world.method_30349());
                if (cart.method_5662(view)) {
                    view.method_71463("PushZ", 0);
                    view.method_71463("PushX", 0);
                    class_11368 data = class_11352.method_71417(logging, world.method_30349(), view.method_71475());
                    cart.method_5651(data);
                }
            }
        }

        if (contraption.containsBlockBreakers())
            award(AllAdvancements.CONTRAPTION_ACTORS);
    }

    protected void disassemble(class_1937 world, class_2338 pos, class_1688 cart) {
        if (cart.method_5685().isEmpty())
            return;
        class_1297 entity = cart.method_5685().getFirst();
        if (!(entity instanceof OrientedContraptionEntity contraption))
            return;
        UUID couplingId = contraption.getCouplingId();

        if (couplingId == null) {
            contraption.yaw = CartAssemblerBlock.getHorizontalDirection(method_11010()).method_10144();
            disassembleCart(cart);
            return;
        }

        Couple<MinecartController> coupledCarts = contraption.getCoupledCartsIfPresent();
        if (coupledCarts == null)
            return;

        // Make sure connected cart is present and being disassembled
        for (boolean current : Iterate.trueAndFalse) {
            MinecartController minecartController = coupledCarts.get(current);
            if (minecartController.cart() == cart)
                continue;
            class_2338 otherPos = minecartController.cart().method_24515();
            class_2680 blockState = world.method_8320(otherPos);
            if (!blockState.method_27852(AllBlocks.CART_ASSEMBLER))
                return;
            if (!CartAssemblerBlock.getActionForCart(blockState, minecartController.cart()).shouldDisassemble())
                return;
        }

        for (boolean current : Iterate.trueAndFalse)
            coupledCarts.get(current).removeConnection(current);
        disassembleCart(cart);
    }

    protected void disassembleCart(class_1688 cart) {
        cart.method_5772();
        if (cart instanceof class_1696) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(method_71402(), Create.LOGGER)) {
                class_11362 view = class_11362.method_71459(logging, field_11863.method_30349());
                cart.method_5786(view);
                class_243 velocity = cart.method_18798();
                view.method_71463("PushX", velocity.field_1352);
                view.method_71463("PushZ", velocity.field_1350);
                class_11368 data = class_11352.method_71417(logging, field_11863.method_30349(), view.method_71475());
                cart.method_5651(data);
            }
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        movementMode = new ServerScrollOptionBehaviour<>(CartMovementMode.class, this);
        behaviours.add(movementMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        AssemblyException.write(view, lastException);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        lastException = AssemblyException.read(view);
        super.read(view, clientPacket);
    }

    public AssemblyException getLastAssemblyException() {
        return lastException;
    }

    public enum CartMovementMode implements class_3542 {
        ROTATE,
        ROTATE_PAUSED,
        ROTATION_LOCKED;

        public static final Codec<CartMovementMode> CODEC = class_3542.method_28140(CartMovementMode::values);

        @Override
        public String method_15434() {
            return name().toLowerCase(Locale.ROOT);
        }
    }

    public void resetTicksSinceMinecartUpdate() {
        ticksSinceMinecartUpdate = 0;
    }

    public void assembleNextTick(class_1688 cart) {
        if (cartToAssemble == null)
            cartToAssemble = cart;
    }

    public boolean isMinecartUpdateValid() {
        return ticksSinceMinecartUpdate >= assemblyCooldown;
    }

}
